import pandas as pd
import os

# folders = sorted(['exp1', 'exp2','exp3','exp4','exp5','exp6','exp7','exp8','exp9','exp10','exp11','exp12'])
folders = sorted(['exp1', 'exp2', 'exp3', 'exp4', 'exp5', 'exp6'])

# Create an empty dataframe to store the merged results
merged_df = pd.DataFrame()

# base = '/data/SREA/coteaching_single_experiment/fNIRS_2/'
base = '/data/SREA/SEEG_SREA_single_experiment/Sleep/'
noise_ratio = input()
base = base + noise_ratio + '/'

# Loop through each directory and CSV file, and read only the second row into a new dataframe
for dirname in folders:
    print(dirname)
    if os.path.isdir(base + dirname):
        filepath = os.path.join(os.path.join(base, dirname, 'results.csv'))
        print(filepath)
        if os.path.isfile(filepath):
            print('Yes')
            # df = pd.read_csv(filepath, nrows=2).tail(1)
            df = pd.read_csv(filepath, skiprows=1, nrows=1, header=None)
            merged_df = pd.concat([merged_df, df], ignore_index=True)

# Write the merged dataframe to a new CSV file
merged_df.to_csv(base + 'merged_results.csv', index=False)
