import numpy as np


def __sampling_segment__(
        start_num_list,
        seg_len,
        seg_num,
        num_class,
        num_level,
):
    # The return list
    total_seg_list = []

    # Sample for each class separately
    for c in range(num_class):
        total_seg = [[] for _ in range(num_level)]
        # Sample for each level separately
        for level in range(num_level):
            # Randomly select the middle points of segments
            total_num = 0
            for file_index in range(len(start_num_list[c][level])):
                for seg_index in range(len(start_num_list[c][level][file_index])):
                    total_num += start_num_list[c][level][file_index][seg_index]
            random_list = np.random.choice(total_num, seg_num)

            for index in random_list:
                index_copy = index
                bingo = False
                for file_index in range(len(start_num_list[c][level])):
                    for seg_index in range(len(start_num_list[c][level][file_index])):
                        if index_copy >= start_num_list[c][level][file_index][seg_index]:
                            index_copy -= start_num_list[c][level][file_index][seg_index]
                        else:
                            total_seg[level].append([file_index, seg_index,
                                                     index_copy - seg_len // 2, index_copy + (seg_len - seg_len // 2)])
                            bingo = True
                            break
                    if bingo:
                        break

        total_seg_list.append(total_seg)

    for c in range(num_class):
        print('-' * 10, 'Results for Class', c, '-' * 10)
        for level in range(num_level):
            print('-' * 10, 'Results for Level', level, '-' * 10)
            print('total_seg_list:\n', total_seg_list[c][level])

    return total_seg_list
