# Discovering Deep Chain-of-Thought Paths Across Broader QA: A General CoT-Decoding Framework for LLMs

---

## Installation

### Python environment
```bash
conda create -n nli-metrics python=3.10 -y
conda activate nli-metrics

pip install -U "openai>=1.40.0" python-dotenv
pip install -U torch torchvision --index-url https://download.pytorch.org/whl/cu121   # pick CUDA build for your GPU
pip install -U transformers accelerate
pip install -U scikit-learn matplotlib
```
## Environment variables (.env in project root)
```bash
OPENAI_API_KEY=
OPENAI_BASE_URL=
```
## Quick Start
```bash
python score_test.py \
  --jsonl ./date_understanding/date_understanding_process.jsonl \
  --model gpt-4o-mini \
  --k 3 \
  --temperature 0.7 \
  --out ./result.csv
```
