import seaborn as sns
from matplotlib import pyplot as plt

x = [0, 10, 20, 30, 40, 50, 60, 70, 80, 90]
press = [4.906, 4.919, 4.933, 4.923, 4.937, 4.957, 4.946, 5.001, 5.137, 5.146]
baseline_press = [5.120] * 10
velo = [0.356, 0.359, 0.361, 0.361, 0.366, 0.376, 0.371, 0.396, 0.444, 0.463]
baseline_velo = [0.434] * 10

color1 = '#038355'
color2 = '#ffc34f'
color3 = '#3d5e80'
color4 = '#c85454'

sns.set_style('whitegrid')
sns.lineplot(x=x, y=press, color=color4, linewidth=4.0, marker='o', markersize=4,label='GNO Point-BERT (fine-tuned)')
sns.lineplot(x=x, y=baseline_press, color=color1, linewidth=4.0, marker='s', markersize=4,label='GNO None')

#plt.title('GNO Point-BERT (fine-tuned)', fontsize=20)
plt.xlabel('Drop Rate (%)', fontsize=16)
plt.ylabel('L-2 Error of Pressure', fontsize=16)

plt.legend(loc='upper right', frameon=True, fontsize=12)
plt.yticks(fontsize=16)
#plt.xlim(0,21)
plt.ylim(4.8,5.3)

for spine in plt.gca().spines.values():
    spine.set_edgecolor('#CCCCCC')
    spine.set_linewidth(1.5)

plt.savefig('robust-press.pdf', dpi=1200, bbox_inches='tight')
#plt.show()

plt.cla()

sns.set_style('whitegrid')
sns.lineplot(x=x, y=velo, color=color4, linewidth=4.0, marker='o', markersize=4,label='GNO Point-BERT (fine-tuned)')
sns.lineplot(x=x, y=baseline_velo, color=color1, linewidth=4.0, marker='s', markersize=4,label='GNO None')

#plt.title('GNO Point-BERT (fine-tuned)', fontsize=20)
plt.xlabel('Drop Rate (%)', fontsize=16)
plt.ylabel('L-2 Error of Velocity', fontsize=16)

plt.legend(loc='upper right', frameon=True, fontsize=12)
plt.yticks(fontsize=16)
#plt.xlim(0,21)
plt.ylim(0.32, 0.5)

for spine in plt.gca().spines.values():
    spine.set_edgecolor('#CCCCCC')
    spine.set_linewidth(1.5)

plt.savefig('robust-velo.pdf', dpi=1200, bbox_inches='tight')