

We provides code and run scripts which are able to generate graphs used in our experiments.

However, we does not provide code for training and evaluating HGNNs on graphs, because the authors SimpleHGN and HGT have provided codes for learning of HGNNs. Their codes can be found in:

- SimpleHGN https://github.com/THUDM/HGB
    - Title: Are we really making much progress? Revisiting, benchmarking and refining the Heterogeneous Graph Neural Networks.
    - Authors: Qingsong Lv*, Ming Ding*, Qiang Liu, Yuxiang Chen, Wenzheng Feng, Siming He, Chang Zhou, Jianguo Jiang, Yuxiao Dong, Jie Tang.
    - In proceedings: KDD 2021.

- HGT https://github.com/acbull/HGT-DGL
    - Title: Heterogeneous Graph Transformer
    - Authors: Ziniu Hu, Yuxiao Dong, Kuansan Wang, Yizhou Sun
    - Published on WWW 2020

## Synthetic Graph Generation

First the used python package needs to be install. They are specified in `requirements.txt`.

Here, take generating SynACM as an example.

1. `cd SynACM`

2. bash `run.sh`

Here run.sh accepts arguments as parameters of SynHING

```sh
bash run.sh <motif_number> <label_number> <i1> <i2> <i3> <out> <dim> <cd>
```
If the arugments are omitted, the default parameters will be used.


The generated graph can then be found in the directory `output_graph`. The structure of the directoies are demostrated as follows:

```
SynACM
├── output_graph
    └── xxx_xxx_xxx_xxx_xxx_xxx
        ├── data_test.csv
        ├── data_train.csv
        ├── data_val.csv
        ├── labels.csv
        ├── link.csv
        ├── motifs
        └── node.csv
```

where the `xxx_xxx_xxx_xxx_xxx_xxx` reflect the parameters used in the format:


```
<motif_number>_<label_number>_<i1>_<i2>_<i3>_<out>_<dim>_<cd>_<S/M>
```

where the last <S/M> is either `S` or `M`, depending on the generated graph being single-label or multi-label.

## Data format

1. link.csv
	4 coulmns: source node ID, target node ID, edge type, edge weight

2. node.csv
	3 columns: node ID, node type, node feature

3. label.csv
	3 columns: node ID, node type(always target node type), node labels

4. data_train.csv / data_val.csv / data_test.csv
	3 columns, same as label.csv

5. motif_X.csv
	4 columns, same as link.csv

