#!/bin/bash
motif_number=${1:-2000}
label_number=${2:-4}
i1=${3:-0.8}
i2=${4:-0.00035}
i3=${5:-0.08}
out=${6:-0.6}
dim=${7:-20}
cd=${8:-0.2}
echo motif_number=$motif_number, label_number=$label_number, intra=\($i1,$i2,$i3\), inter=$out, feat_dim=$dim, cd=$cd
mkdir -p output_graph
python3 generate_g20_dblp.py --motif_numbers $motif_number --label_numbers $label_number
python3 add_bonus_node.py --motif_number $motif_number
python3 merge.py --motif_numbers $motif_number --label_numbers $label_number --outcluster_threshold $out \
--incluster_threshold $i1 $i2 $i3 --feature_dim $dim --feature_cd $cd --singlelabel
python3 post_process.py --motif_numbers $motif_number --label_numbers $label_number --outcluster_threshold $out \
--incluster_threshold $i1 $i2 $i3 --feature_dim $dim --feature_cd $cd --singlelabel
