from LIReC.lib.pslq_utils import pslq, poly_eval
import mpmath as mp
import matplotlib.pyplot as plt
import numpy as np
mp.mp.prec = 120
pslq([mp.mpf('0.48407825134406402814374376391345614591'), mp.mpf('0.24670008170107546891234056368726178965')], None, mp.inf, mp.inf, verbose=True)

# These are the errors that pslq will emit on verbose printing, transcribed for convenience.
errors = [0.008, 0.001, 0.0005, 0.0001, 5.0e-5, 1.0e-5, 5.0e-6, 2.0e-6, 6.0e-7, 8.0e-8, 2.0e-8, 9.0e-9, 5.0e-9, 8.0e-11, 4.0e-12, 5.0e-13, 8.0e-14, 1.0e-14, 2.0e-15, 4.0e-16, 2.0e-16, 5.0e-17, 2.0e-17, 7.0e-18, 3.0e-19, 2.0e-20, 8.0e-21, 1.0e-21, 6.0e-22, 2.0e-22, 2.0e-23, 4.0e-24, 4.0e-25, 4.0e-26, 2.0e-26, 5.0e-27, 3.0e-27, 2.0e-27, 2.0e-27, 1.0e-26, 5.0e-26, 9.0e-26, 4.0e-25, 4.0e-24, 1.0e-23, 6.0e-23, 3.0e-21, 9.0e-21, 2.0e-20, 1.0e-19, 9.0e-19, 7.0e-18, 3.0e-16, 2.0e-15, 5.0e-14, 1.0e-13, 4.0e-13, 2.0e-12, 5.0e-12, 2.0e-11, 6.0e-11, 8.0e-10, 2.0e-9, 7.0e-9, 6.0e-8, 2.0e-7, 1.0e-6, 4.0e-6, 3.0e-5, 9.0e-5, 0.0002, 0.0004, 0.002, 0.008, 0.01, 0.05, 0.3, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0]
errors = np.array([float(mp.floor(-mp.log(e, 2))) for e in errors])
argmax = errors.argmax()
maxprec = errors[argmax]
failsafe = next((i+argmax,e) for i,e in enumerate(errors[argmax:]) if 2 * e < maxprec)

fig, ax = plt.subplots(figsize=(6,4))
ax.plot(errors, c='k')
tol = mp.mp.prec * 0.75
ax.scatter([failsafe[0]], [failsafe[1]], c='red', s=50)
ax.plot([tol for i in range(len(errors))], 'k--')
ax.set_xlabel('step number')
ax.set_ylabel('precision')
fig.tight_layout()
plt.show()
