# SONAR: Spectral-Contrastive Audio Residuals for Robust Deepfake Detection

This repository contains the official implementation of **SONAR**, a frequency-guided dual-path framework for audio deepfake detection.  
SONAR addresses the **spectral bias** of deep networks by explicitly disentangling **low-frequency content** from **high-frequency residuals**, turning the “HF hole” left by generators into a decisive discriminative signal.  
The result: faster convergence, stronger generalization, and state-of-the-art performance on ASVspoof and In-the-Wild benchmarks.  

---

## ✨ Key Features

- **Dual-path architecture:**  
  Content Feature Extractor (CFE) for LF semantic content and Noise Feature Extractor (NFE) for HF residuals.  

- **Learnable SRM filters:**  
  A bank of trainable SRM filters isolates high-frequency cues critical for spoofing detection.  

- **Latent JS alignment:**  
  Jensen–Shannon loss aligns LF–HF embeddings for reals while repelling fakes, creating disjoint manifolds in feature space.  

- **Architecture-agnostic:**  
  SONAR operates at the representation level, and can attach to different backbones.  

- **Fast convergence & SOTA:**  
  Reaches new best EERs on ASVspoof~2021 (1.57% DF / 6.00% ITW) in only 12 epochs.  
  A finetuned variant improves further to 1.45% / 5.43% in just 4 epochs.  

---

## 📂 Repository Structure

- `main.py` — entry point for training, evaluation, and inference (supports multi-GPU DDP).  
- `guided_model.py` — defines the dual-path architecture (CFE, NFE, cross-attention fusion).  
- `data_utils_SSL.py` — data loaders for ASVspoof and In-the-Wild datasets.  
- `srm_filters.py` — learnable constrained SRM filters for HF extraction.  
- `eval_metric_LA.py` — evaluation utilities (EER and related metrics).  
- `simple_classifier.py` — a lightweight two-layer classifier for SONAR-Lite experiments.  
- Utility scripts for visualization (cosine similarity histograms, embedding distributions).  

---

## ⚙️ Installation

Requirements:
- Python 3.7+  
- PyTorch 1.10+  

Install dependencies:
```bash
pip install -r requirements.txt



/path/to/dataset/
├── LA/
│   ├── ASVspoof2019_LA_train/
│   ├── ASVspoof2019_LA_dev/
│   └── ASVspoof2021_LA_eval/
└── DF/
    └── ASVspoof2021_DF_eval/


Training:
CUDA_VISIBLE_DEVICES=0 python main_SSL_LA.py \
  --track=LA --lr=1e-6 --batch_size=14 --loss=WCE

Evaluation:
python main_SSL_LA.py --track=LA --is_eval --eval \
  --model_path /path/to/best_model.pth \
  --eval_output eval_scores_LA.txt

python main_SSL_DF.py --track=DF --is_eval --eval \
  --model_path /path/to/best_model.pth \
  --eval_output eval_scores_DF.txt
