# EVAttack

Follow the steps below to set up the environment and get started.

---

## Environment Setup

We recommend using **conda** for reproducibility. Create a fresh environment with Python 3.10:

```bash
conda create --name thename python=3.10
conda activate thename
```

---

## Install Dependencies

Install all required packages using the provided `requirements.txt`:

```bash
pip install -r requirements.txt
```

This installs:

- PyTorch 2.1.0 (CUDA 12.1 build), TorchVision, TorchAudio
- PyTorch Geometric core wheels and extensions
- Common ML utilities (seaborn, ml-collections, sacred, wandb, ogb, etc.)

> If you don’t have `requirements.txt` yet, create it with the contents discussed in this repo’s setup instructions.

---

## Local Development Packages

Some local modules need to be installed in **development mode**. From the project root, run:

```bash
cd GNNSetup && python setup.py develop && cd ..
cd Eva && python setup.py develop && cd ..
```

---

## Quick Start

After installation, run an example training or attack script:

```bash
Python bin/make_splits.py
python bin/vanilla_train.py 
Python bin/make_attack.py
```
