source /opt/conda/bin/activate

cd ../

dataset_name="citeseer"
model_name="GPRGNN"
train_attack_names=("LRBCD" "PRBCD" "EVAFAST") 
for train_attack_name in "${train_attack_names[@]}"
do
    echo "DATASET=$dataset_name, MODEL=$model_name, TRAIN_ATTACK=$train_attack_name"
    python expr-robust-train.py with "dataset_name=$dataset_name" "model_name=$model_name" "train_attack_name=$train_attack_name"
    python expr-robust-train.py with "dataset_name=$dataset_name" "model_name=$model_name" "train_attack_name=$train_attack_name" "inductive=True"
done


dataset_name="cora_ml"
model_name="GPRGNN"
train_attack_names=("PRBCD" "EVAFAST") 
for train_attack_name in "${train_attack_names[@]}"
do
    echo "DATASET=$dataset_name, MODEL=$model_name, TRAIN_ATTACK=$train_attack_name"
    python expr-robust-train.py with "dataset_name=$dataset_name" "model_name=$model_name" "train_attack_name=$train_attack_name"
    python expr-robust-train.py with "dataset_name=$dataset_name" "model_name=$model_name" "train_attack_name=$train_attack_name" "inductive=True"
done


dataset_name="pubmed"
model_name="GPRGNN"
train_attack_names=("PRBCD" "EVAFAST") 
for train_attack_name in "${train_attack_names[@]}"
do
    echo "DATASET=$dataset_name, MODEL=$model_name, TRAIN_ATTACK=$train_attack_name"
    python expr-robust-train.py with "dataset_name=$dataset_name" "model_name=$model_name" "train_attack_name=$train_attack_name"
    python expr-robust-train.py with "dataset_name=$dataset_name" "model_name=$model_name" "train_attack_name=$train_attack_name" "inductive=True"
done
