source /opt/conda/bin/activate

cd ../

dataset_names=("cora_ml" "pubmed" "citeseer")
train_attack_names=("PRBCD" "EVAFAST" "LRBCD") 
model_names=("GCN" "GAT" "APPNP" "GPRGNN" "ChebNetII")

for dataset_name in "${dataset_names[@]}"
do
    for train_attack_name in "${train_attack_names[@]}"
    do
        for model_name in "${model_names[@]}"
        do
                echo "DATASET=$dataset_name, MODEL=$model_name, TRAIN_ATTACK=$train_attack_name"
                python expr-robust-train.py with "dataset_name=$dataset_name" "model_name=$model_name" "train_attack_name=$train_attack_name"
                python expr-robust-train.py with "dataset_name=$dataset_name" "model_name=$model_name" "train_attack_name=$train_attack_name" "inductive=True"
        done
    done
done
