source /opt/conda/bin/activate

cd ../

dataset_names=("cora_ml" "pubmed" "citeseer")
attack_names=("PRBCD" "PGD" "LRBCD" "EVAFAST")
model_names=("GCN" "GAT" "APPNP" "GPRGNN" "ChebNetII")
train_attack_names=("PRBCD" "EVAFAST" "LRBCD")
epsilons=("0.02" "0.05" "0.1")

for dataset_name in "${dataset_names[@]}"
do
    for attack_name in "${attack_names[@]}"
    do
        for epsilon in "${epsilons[@]}"
        do
            for model_name in "${model_names[@]}"
            do
                for train_attack_name in "${train_attack_names[@]}"
                do
                        echo "ATTACK=$attack_name, EPSILON=$epsilon, DATASET=$dataset_name, MODEL=$model_name, TRAIN_ATTACK=$train_attack_name"
                        python expr-attack.py with "dataset_name=$dataset_name" "model_name=$model_name" "train_attack_name=$train_attack_name" "attack_name=$attack_name" "epsilon=$epsilon"
                        python expr-attack.py with "dataset_name=$dataset_name" "model_name=$model_name" "train_attack_name=$train_attack_name" "attack_name=$attack_name" "epsilon=$epsilon" "inductive=True"
                done
            done
        done
    done
done
