import torch
from utils.storage import TensorHash

def accuracy(model, attr, adj, labels, evaluation_mask):
    model.eval()
    with torch.no_grad():
        logits = model(attr, adj)
        preds = logits.max(1)[1].type_as(labels)
        acc = preds.eq(labels).double()
        acc = acc[evaluation_mask].mean()
    return acc.item()

def model_storage_label(model_name, model_params, dataset_info, inductive, split_name, self_training=False, robust_training=False, train_attack_name='PRBCD', robust_epsilon=0.0, suffix=""):
    model_config_hash = TensorHash.hash_model_params(model_name, model_params)
    setting_ind = "ind" if inductive else "tr"
    setting_st = "-st" if self_training else ""
    setting_rt = "-rt_"+train_attack_name+'_'+str(robust_epsilon).replace('.', '_') if robust_training else ""
    return f"{model_name}-{model_config_hash}-{setting_ind}{setting_st}{setting_rt}-{dataset_info.dataset_name}-{split_name}-{suffix}"
