dset_name=hl
ctx_mode=video_tef
#v_feat_types=slowfast_clip
v_feat_types=slowfast_clip
#v_feat_types=clip
#t_feat_types=clip
t_feat_types=clip
results_root=results/qvhighlights/ablation-new/loss/no_loss_all_modules
exp_id=ablation-no_loss_all_modules

######## data paths
train_path=data/highlight_train_release.jsonl
#train_path=data/highlight_train_release_paraphrased.jsonl
#train_path=data/highlight_train_release_paraphrased_openai.jsonl
eval_path=data/highlight_val_release.jsonl
eval_split_name=val

######## setup video+text features
feat_root=../Datasets/qvhl/features

# video features
v_feat_dim=0
v_feat_dirs=()
if [[ ${v_feat_types} == *"slowfast"* ]]; then
  v_feat_dirs+=(${feat_root}/slowfast_features)
  (( v_feat_dim += 2304 ))  # double brackets for arithmetic op, no need to use ${v_feat_dim}
fi
if [[ ${v_feat_types} == *"clip"* ]]; then
  v_feat_dirs+=(${feat_root}/clip_features)
  (( v_feat_dim += 512 ))
fi
if [[ ${v_feat_types} == *"blip"* ]]; then
  v_feat_dirs+=(${feat_root}/blip_video_features)
  (( v_feat_dim += 768 ))
fi

echo $v_feat_dim
echo ${v_feat_dirs[@]}

# text features
t_feat_dim=0
t_feat_dirs=()
if [[ ${t_feat_types} == *"clip"* ]]; then
  t_feat_dirs+=(${feat_root}/clip_aug_text_features_openai)
  (( t_feat_dim += 512 ))  # double brackets for arithmetic op, no need to use ${v_feat_dim}
fi
if [[ ${t_feat_types} == *"blip"* ]]; then
  t_feat_dirs+=(${feat_root}/blip_aug_text_features_openai)
  (( t_feat_dim += 768 ))
fi

echo $t_feat_dim
echo ${t_feat_dirs[@]}


#### training
bsz=32
dec_layers=3
enc_layers=3
bicmf_layers=2
hard_pos_neg_loss_coef=10
contrastive_align_loss_coef=.1
cos_sim_loss_coef=1

PYTHONPATH=$PYTHONPATH:. python video_light/train.py \
--dset_name ${dset_name} \
--ctx_mode ${ctx_mode} \
--train_path ${train_path} \
--eval_path ${eval_path} \
--eval_split_name ${eval_split_name} \
--v_feat_dirs ${v_feat_dirs[@]} \
--v_feat_dim ${v_feat_dim} \
--t_feat_dirs ${t_feat_dirs[@]} \
--t_feat_dim ${t_feat_dim} \
--bsz ${bsz} \
--dec_layers ${dec_layers} \
--enc_layers ${enc_layers} \
--bicmf_layers ${bicmf_layers} \
--mr_to_hd_loss \
--hard_pos_neg_loss \
--hard_pos_neg_loss_coef ${hard_pos_neg_loss_coef} \
--cos_sim_loss_coef ${cos_sim_loss_coef} \
--contrastive_align_loss \
--contrastive_align_loss_coef ${contrastive_align_loss_coef} \
--results_root ${results_root} \
--exp_id ${exp_id} \
--device 0 \
--hidden_dim 256 \
--n_epoch 150 \
${@:1}


#--mr_to_hd_loss \
#--hard_pos_neg_loss \
#--contrastive_align_loss \
#--contrastive_align_loss_coef ${contrastive_align_loss_coef} \

#cd /content/
#git clone https://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@github.com/dpaul06/VideoLiMo.git -b video_light
#cd /content/VideoLiMo/
#pip install -r requirements.txt
#bash video_light/scripts/qvhl/ablation.sh
#rsync -ah --progress /content/VideoLiMo/results /content/drive/MyDrive/Video/VideoLiMo
