dset_name=hl
ctx_mode=video_tef
#v_feat_types=slowfast_clip
v_feat_types=slowfast_clip_blip
#v_feat_types=clip
#t_feat_types=clip
t_feat_types=clip_blip
results_root=results/qvhighlights/final
exp_id=ft-bf-bicmf_2-fr-edl_3-conval-cal_0.8-csl-hl-tcl

######## data paths
train_path=data/highlight_train_release.jsonl
#train_path=data/highlight_train_release_paraphrased.jsonl
#train_path=data/highlight_train_release_paraphrased_openai.jsonl
eval_path=data/highlight_val_release.jsonl
eval_split_name=val

######## setup video+text features
feat_root=../Datasets/qvhl/features

# video features
v_feat_dim=0
v_feat_dirs=()
if [[ ${v_feat_types} == *"slowfast"* ]]; then
  v_feat_dirs+=(${feat_root}/slowfast_features)
  (( v_feat_dim += 2304 ))  # double brackets for arithmetic op, no need to use ${v_feat_dim}
fi
if [[ ${v_feat_types} == *"clip"* ]]; then
  v_feat_dirs+=(${feat_root}/clip_features)
  (( v_feat_dim += 512 ))
fi
if [[ ${v_feat_types} == *"blip"* ]]; then
  v_feat_dirs+=(${feat_root}/blip_video_features)
  (( v_feat_dim += 768 ))
fi

echo $v_feat_dim
echo ${v_feat_dirs[@]}

# text features
t_feat_dim=0
t_feat_dirs=()
if [[ ${t_feat_types} == *"clip"* ]]; then
  t_feat_dirs+=(${feat_root}/clip_text_features)
  (( t_feat_dim += 512 ))  # double brackets for arithmetic op, no need to use ${v_feat_dim}
fi
if [[ ${t_feat_types} == *"blip"* ]]; then
  t_feat_dirs+=(${feat_root}/blip_aug_text_features_openai)
  (( t_feat_dim += 768 ))
fi

echo $t_feat_dim
echo ${t_feat_dirs[@]}


#### training
bsz=32
dec_layers=3
enc_layers=3
bicmf_layers=2
max_v_l=75
contrastive_align_loss_coef=0.8
hard_pos_neg_loss_coef=10
main_metric="MR-full-R1@0.3"
#pretrain_path=results/pretrain/hl-video_tef-pt-bf-bicmf_2-only_csl-cal_0.2-fr-edl_3-conval-2024_09_03_07_27_03/model_best.ckpt
#pretrain_path=results/pretrain/hl-video_tef-pt-bf-unicmf_4-only_csl-cal_0.2-fr-edl_3-conval-2024_09_05_03_59_18/model_best.ckpt
#pretrain_path=results/pretrain/hl-video_tef-pt-bf-bicmf_2-only_csl-cal_0.2-fr-edl_3-conval-2024_09_07_18_59_31/model_best.ckpt
#pretrain_path=results/pretrain/hl-video_tef-pt-bf-bicmf_2-csl-cal_0.2-fr-edl_3-conval-hl-tcl-2024_09_10_07_30_28/model_best.ckpt
pretrain_path=results/pretrain/final/hl-video_tef-pt-bf-bicmf_2-fr-edl_3-conval-cal_0.2-csl-hl-tcl-2024_09_27_17_57_44/model_best.ckpt

PYTHONPATH=$PYTHONPATH:. python video_light/train.py \
--dset_name ${dset_name} \
--ctx_mode ${ctx_mode} \
--resume ${pretrain_path} \
--train_path ${train_path} \
--eval_path ${eval_path} \
--eval_split_name ${eval_split_name} \
--v_feat_dirs ${v_feat_dirs[@]} \
--v_feat_dim ${v_feat_dim} \
--t_feat_dirs ${t_feat_dirs[@]} \
--t_feat_dim ${t_feat_dim} \
--bsz ${bsz} \
--dec_layers ${dec_layers} \
--enc_layers ${enc_layers} \
--bicmf_layers ${bicmf_layers} \
--mr_to_hd_loss \
--hard_pos_neg_loss \
--hard_pos_neg_loss_coef ${hard_pos_neg_loss_coef} \
--contrastive_align_loss \
--contrastive_align_loss_coef ${contrastive_align_loss_coef} \
--results_root ${results_root} \
--exp_id ${exp_id} \
--device 0 \
--hidden_dim 256 \
${@:1}


#--mr_to_hd_loss \
#--hard_pos_neg_loss \
