# Data

## Traveling Salesman Problem

### TSP-50 & TSP-100

Both the training and evaluation data of TSP-50 and TSP-100 data are taken from [chaitjo/learning-tsp](https://github.com/chaitjo/learning-tsp).

### TSP-500, TSP-1000, and TSP-10000

The evaluation data of TSP-500, TSP-1000, and TSP-10000 are taken from [Spider-scnu/TSP](https://github.com/Spider-scnu/TSP).

The training data of TSP-500, TSP-1000, and TSP-10000 are generated by the following commands.

```bash
python -u generate_data.py \
  --min_nodes 500 \
  --max_nodes 500 \
  --num_samples 128000 \
  --batch_size 128 \
  --filename "/your/path/to/tsp500_train_concorde.txt" \
  --seed 1234
```

python -u generate_tsp_data.py  --min_nodes 100  --max_nodes 100  --num_samples 1280000  --batch_size 1280  --filename "./tsp/tsp100_train_concorde_my128w.txt" --seed 1234



python -u generate_tsp_data.py  --min_nodes 200  --max_nodes 200  --num_samples 1280000  --batch_size 1280  --filename "./tsp/tsp200_train_concorde_my128w.txt" --seed 1234


python -u generate_tsp_data.py  --min_nodes 500  --max_nodes 500  --num_samples 128000  --batch_size 128  --filename "./tsp/tsp500_train_concorde_my12w.txt" --seed 1234


python -u generate_tsp_data.py  --min_nodes 500  --max_nodes 500  --num_samples 640000  --batch_size 128  --filename "./tsp/tsp500_train_concorde_my64w.txt" --seed 1234

```bash
python -u generate_data.py \
  --min_nodes 1000 \
  --max_nodes 1000 \
  --num_samples 64000 \
  --batch_size 128 \
  --filename "/your/path/to/tsp1000_train_concorde.txt" \
  --seed 1234
```


python -u generate_tsp_data.py  --min_nodes 1000  --max_nodes 1000  --num_samples 128000  --batch_size 128  --filename "./tsp1000_train_concorde_my12w.txt"  --seed 1234



python -u generate_tsp_data.py  --min_nodes 1000  --max_nodes 1000  --num_samples 640000  --batch_size 128  --filename "./tsp1000_train_concorde_my64w.txt"  --seed 1234


```bash
python -u generate_data.py \
  --min_nodes 10000 \
  --max_nodes 10000 \
  --num_samples 6400 \
  --batch_size 128 \
  --filename "/your/path/to/tsp10000_train_concorde.txt" \
  --seed 1234
```

python -u generate_tsp_data.py  --min_nodes 10000  --max_nodes 10000  --num_samples 6400  --batch_size 128  --filename "./tsp/tsp10000_train_concorde_my6k.txt"  --seed 1234

python -u generate_tsp_data.py  --min_nodes 10000  --max_nodes 10000  --num_samples 32000  --batch_size 128  --filename "./tsp/tsp10000_train_concorde_my3w.txt"  --seed 1234


## Maximal Independent Set

### SATLIB

The training and evaluation data of SATLIB are taken from [DIMESTeam/DIMES](https://github.com/DIMESTeam/DIMES).

### ER-[700-800]

The evaluation data of ER-[700-800] are also taken from [DIMESTeam/DIMES](https://github.com/DIMESTeam/DIMES).

The training data of ER-[700-800] are generated by the following commands.

```bash
cd mis-benchmark-framework || exit

python -u main.py gendata \
    random \
    None \
    /your/path/to/data_er/train \
    --model er \
    --min_n 700 \
    --max_n 800 \
    --num_graphs 163840 \
    --er_p 0.15
```

```bash
cd mis-benchmark-framework || exit

mkdir -p /tmp/gpus
touch /tmp/gpus/.lock
touch /tmp/gpus/0.gpu

python -u main.py \
    solve \
    kamis \
    /your/path/to/data_er/train \
    /your/path/to/data_er/train_annotations \
    --time_limit 60
```
