# Code README for paper "Causal Contextual Bandits with Targeted Interventions"

## Folder organization
This folder `Supplemental_Code_Paper1203` contains all code-related supplementary material. There are three experiments reported in the main paper; folders `Experiment1`, `Experiment2`, and `Experiment3` contain the code corresponding to the respective experiments.

## Requirements

`requirements.txt` contains the Python package dependencies. You can use `pip install` to install them.


## Experiment 1
We combine training and evaluation code into the same `.py` files; this is because the data is produced synthetically by the training code, and there is no intermediate model saved to disk; therefore, keeping it in the same file makes it easier to run. 

Specifically, for this experiment, follow the below steps:

 1. Run all 5 files `expt_setting1.py` through `expt_setting5.py`.
 2. Then run `final_experiment1.py`
 3. `experiment1_plot.png` is the final plot.

#### Additional details

 - Parameterizations of each of the 5 settings is in `config_setting1.py` through `config_setting5.py`.
 - Each of the above config files are a Python `dict` that contain parameters & hyperparameters for that setting; each config file contains self-explanatory comments describing each element.
 - Running the code may not produce the *exact* same graphs as in the paper (there can be slight variations) due to inherent variance as a result of sampling from distributions; please increase the number of runs in config files (key `train_runs_list`) to further reduce variance.
 - Ensure there are no other folders except folders names `Var*`. For example, remove `__pycache__` if it gets created.

## Experiment 2
For this experiment, follow the below steps:

 1. Run `experiment2.py`.   (Note: parameterization is given in `config.py`)
 2. Then run `experiment2_plot.py`
 3. `experiment2.png` contains the final plot.

## Experiment 3
For this experiment, follow the below steps:

 1. Run `experiment3.py`.   (Note: parameterization is given in `config.py`)
 2. Then run `experiment3_plot.py`
 3. `experiment3.png` contains the final plot.

## Results
The three main plots in the paper would get created in the below paths after the code is run:

 1. Experiment 1: `Code/Experiment1/experiment1_plot.png`
 2. Experiment 2: `Code/Experiment2/experiment2.png`
 3. Experiment 3: `Code/Experiment3/experiment3.png`

