params = {
    'var_ranges': {    # Define ranges of the variables
        'range_C1' : 16,   # Range of C1; in this case, it is [0, ..., 15]
        'range_C0' : 2,  # Range of C0
        'range_x' : 4, # Range of X
        'domain_y' : [-0.25, 0, 1, 4]  # Set of values Y can take
    },
    'graph': {  # Conditional probability distributions that are not randomized
        'y_distr' :  [[[0, 0, 0, 1] if x==2 else [1, 0, 0, 0] for x in range(4)]] + 
                        [[[0, 0, 1, 0] if x==3 else [0, 1, 0, 0] for x in range(4)]] # y_distr[i][j] = P(y|c0=i, x=j)
    },
    'eval': {  # Hyperparameters for evaluation
        'train_runs_list' : [100]*5,  # Number of runs for each of the 5 settings
        'test_runs_per_train_run_list' : [1]*5,  # Keep it at 1
        'train_T_list' : [8, 16, 24, 32, 40], # T
        'test_T_list' : [30]*5, # Number of post-deployment runs for each train run, to get lower-variance estimates
        'alpha_list' : [1/2]*5  # Alpha
    }
}

print(params)