class SamplerConfig:
    def __init__(
        self,
        # sampler
        path_type = "Linear",
        prediction = "velocity",
        loss_weight = None,
        sample_eps = None,
        train_eps = None,
        
        device = 'cpu',
        sample_generator = None,
        # model
        model = None,
        cfg_scale=1.0,
        num_sampling_steps=250,
    ):
        super(SamplerConfig, self).__init__()
  
        # flow path configuration
        assert path_type in ["Linear", "GVP", "VP"]
        self.path_type = path_type
        assert prediction in ["velocity", "score", "noise"]
        self.prediction = prediction
        assert loss_weight in [None, "velocity", "likelihood"]
        self.loss_weight = loss_weight
        self.sample_eps = sample_eps
        self.train_eps = train_eps
        
        self.device = device
        self.sample_generator = sample_generator
        # model
        self.model = model

        # scale of classifier-free guidance
        self.cfg_scale = cfg_scale
        self.num_sampling_steps = num_sampling_steps