'''
# run
python run.py ./results/simulation/configs/params_all.json 1> run.log 2>&1 
'''
import json 
import sys
import os
import numpy as np, pandas as pd
from subprocess import call

    
def load_config(cfg_file):
    with open(cfg_file) as f:
        params_all = json.load(f)
    cfgs = list(params_all.values())
    return cfgs

def cfg_string(cfg):
    ks = sorted(cfg.keys())
    cfg_str = ','.join(['%s:%s' % (k, str(cfg[k])) for k in ks])
    return cfg_str.lower()

def is_used_cfg(cfg, used_cfg_file):
    cfg_str = cfg_string(cfg)
    used_cfgs = read_used_cfgs(used_cfg_file)
    return cfg_str in used_cfgs

def read_used_cfgs(used_cfg_file):
    used_cfgs = set()
    with open(used_cfg_file, 'r') as f:
        for l in f:
            used_cfgs.add(l.strip())

    return used_cfgs

def save_used_cfg(cfg, used_cfg_file):
    with open(used_cfg_file, 'a') as f:
        cfg_str = cfg_string(cfg)
        f.write('%s\n' % cfg_str)

def run(cfg_file):
    configs = load_config(cfg_file)

    used_cfg_file = os.path.join(configs[0]['output_dir'], 'configs', 'used_configs.txt' )

    if not os.path.isfile(used_cfg_file):
        f = open(used_cfg_file, 'w')
        f.close()

    for i in range(len(configs)):
        cfg = configs[i]

        if is_used_cfg(cfg, used_cfg_file):
            print('Configuration used, skipping')
            continue

        save_used_cfg(cfg, used_cfg_file)

        print('------------------------------')
        print('\n'.join(['%s: %s' % (str(k), str(v)) for k,v in cfg.items()]))

        flags = ' '.join('-%s %s' % (k,str(v)) for k,v in cfg.items())


        print('\ncall: ', 'python train.py %s' % flags)
        call('python train.py %s' % flags, shell=True)



if __name__ == "__main__":
    if len(sys.argv) < 2:
        # print('Usage: python cfr_param_search.py <config file>')
        print('use default path: ./results/simulation/configs/params_all.json')
        run('./results/simulation/configs/params_all.json')
    else:
        run(sys.argv[1])

