
model_name=STFTRAFT
pipeline=STFTRAFT
channel_independence=1


seq_len=720
pred_len=96
alpha=0.05
window_size=16
hop_size=8
learning_rate=0.001


echo "Running model $model_name with pred_len $pred_len, alpha $alpha, window_size $window_size, hop_size $hop_size"

python -u run.py \
  --pipeline $pipeline \
  --task_name long_term_forecast \
  --is_training 1 \
  --root_path ./data/unimodal/weather/ \
  --data_path weather.csv \
  --model_id weather_720_96 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len $seq_len \
  --label_len 48 \
  --pred_len $pred_len \
  --e_layers 2 \
  --d_layers 1 \
  --factor 3 \
  --enc_in 7 \
  --dec_in 7 \
  --c_out 7 \
  --des 'Exp' \
  --itr 1 \
  --channel_independence $channel_independence \
  --n_period 1 \
  --window_size $window_size \
  --hop_size $hop_size \
  --alpha $alpha \
  --learning_rate $learning_rate \
  --bz1 128 \
  --bz2 64 
