## Shapley-NAS: Discovering Operation Contribution for Neural Architecture Search

This is the pytorch implementation for the paper: *Shapley-NAS: Discovering Operation Contribution for Neural Architecture Search*, 
which is in submission to ICLR2022. This repo contains the implementation of architecture search and evaluation algorithms on CIFAR-10 and ImageNet using our proposed Shapley-NAS.

In this paper, we propose a Shapley value based operation contribution evaluation method (Shapley-NAS) for neural architecture search. Differentiable architecture search (DARTS) acquires the expected architectures by optimizing the architecture parameters with gradient descent, which benefits from the high efficiency due to the significantly reduced search cost. However, DARTS leverages the learnable architecture parameters of the supernet to represent the operation importance during the search process, which fails to reveal the actual impacts of operations on the task performance and therefore harms the effectiveness of obtained architectures. On the contrary, we evaluate the direct influence of operations on accuracy via Shapley value for supernet optimization and architecture discretization, so that the optimal architectures are acquired by selecting the operations that contribute significantly to the tasks. Specifically, we iteratively employ Monte-Carlo sampling based algorithm with early truncation to efficiently approximate the Shapley value of operations, and update weights of the supernet whose architecture parameters are assigned with the operation contribution evaluated by Shapley value. At the end of the search process, operations with the largest Shapley value are preserved to form the final architecture. Extensive experiments on CIFAR-10 and ImageNet for image classification and on NAS-Bench-201 for optimal architecture search show that our Shapley-NAS outperforms the state-of-the-art methods by a sizable margin with light search cost.
## Quick Start

### Prerequisites

- python>=3.5
- pytorch>=1.1.0
- torchvision>=0.3.0 




### Architecture Search on CIFAR-10

```
export CUDA_VISIBLE_DEVICES=0
python -W ignore train_search.py    \
--batch_size 256    \
--shapley_momentum 0.8  \
--save cifar10_shapley    \
--data cifar10_data
```
 
### Architecture Search on ImageNet

```
export CUDA_VISIBLE_DEVICES=0,1
python -W ignore train_search_imagenet.py    \
--batch_size 1024    \
--save imagenet_shapley    \
--shapley_momentum 0.8  \
--data /ILSVRC2012  \
```
### Architecture Evaluation on CIFAR-10

```
export CUDA_VISIBLE_DEVICES=0
python -W ignore train.py   \
--data cifar10_data \
--save train_cifar10   \
--auxiliary \
--cutout    \

```

### Architecture Evaluation on ImageNet

```
export CUDA_VISIBLE_DEVICES=0,1
python -W ignore train_imagenet.py \
 --tmp_data_dir /ILSVRC2012 \
 --save train_imagenet \
 --workers 16   \
 --auxiliary \
 --note imagenet_shapley    \
```