# Newton Informed Neural Operator for Computing Multiple Solutions of Nonlinear Partials Differential Equations

## Datasets
Datasets can be accessed via [this link](https://drive.google.com/drive/folders/1E-q7niAIkgdaP0lF9zDVNQvNmNGXotQn?usp=sharing) under the MIT license. 
The datasets are generated by code with dataset - `A.npy` - `S.npy`
```train
python GrayScott.py 
```

## Requirements
To set up the required environment:

```bash
conda install --file requirements.txt
```

##  Training
Please put all the data and change the path in the scripts.

### case 1 convex problem 
Train with pde loss
```train 
python newton_single_solution.py --model_type DeepONet --num_channel_u 48 --num_layer 4 --num_channel_f 2    --final_div_factor 50 --weight_decay 1e-6 --lr 1e-4   --batch_size 50 --epochs 1000 --loss_type 'pde' 

```
Train with l2 loss
```train
python newton_single_solution.py --model_type DeepONet --num_channel_u 48 --num_layer 4 --num_channel_f 2    --final_div_factor 50 --weight_decay 1e-6 --lr 1e-4   --batch_size 50 --epochs 1000 --loss_type 'l2' 

```

### case 2 non-convex problem 
```train
python newton.py --model_type DeepONet --num_channel_u 48 --num_layer 4 --num_channel_f 2    --final_div_factor 50 --weight_decay 1e-6 --lr 1e-4   --batch_size 50 --epochs 1000 --loss_type 'pde' 

```
  
### GrayScott
```train
python newton_mutiple_solution.py --model_type DeepONet --num_channel_u 48 --num_layer 4 --num_channel_f 2    --final_div_factor 50 --weight_decay 1e-6 --lr 1e-4   --batch_size 50 --epochs 1000 --loss_type 'pde' 

```



