
import argparse

def load_args():
    parser = argparse.ArgumentParser(description='Comparing different SGD variants')
    parser.add_argument('--optim-method', type=str, default='SGD', help='Which optimizer to use.')
    parser.add_argument('--step-mode', type=str, default='1t',
                        help='Which step-size mode to use for bandwidth.') #### '1t', '1sqrt', 'linear'
    parser.add_argument('--epoch-mode', type=int, default=0,
                        help='decrease the step-size every epoch or every iteration. For example 1/t or 1/sqrt') #### True (1) or False (0)
    parser.add_argument('--eta0', type=float, default=0.1,
                        help='Initial learning rate (default: 0.1).')
    parser.add_argument('--alpha', type=float, default=0.1,
                        help='Decay factor (default: 0.1).')
    parser.add_argument('--ratio', type=float, default= 1,
                        help='Bandwidth factor (default: 1).')
    parser.add_argument('--nesterov', action='store_true',
                        help='Use nesterov momentum (default: False).')
    parser.add_argument('--momentum', type=float, default=0.0,
                        help='Momentum used in optimizer (default: 0).')
    parser.add_argument('--weight-decay', type=float, default=0.0005,
                        help='Weight decay used in optimizer (default: 0.0005).')
    parser.add_argument('--milestones', nargs='*', default=[],
                        help='Used for SGD step decay or SGD bandwidth_based step-size denoting when to decrease the step size or when to apply the up-down policy, unit in iteration (default: []).')
    parser.add_argument('--interval-mode', type=str, default='fixed',
                        help='Which interval mode to use for bandwidth.') #### 'fixed','exponentially growing', 'linear growing'
    parser.add_argument('--num-bandloop', type=int, default=1,
                        help='Which the number of bandloop to use for bandwidth.') #### 
    parser.add_argument('--clip', type=float, default=0.25,
                        help='Which the number of bandloop to use for bandwidth.') #### 
    parser.add_argument('--train-epochs', type=int, default=100,
                        help='Number of train epochs (default: 100).')
    parser.add_argument('--batchsize', type=int, default=16,
                        help='How many images in each train epoch (default: 16).')
    parser.add_argument('--validation', action='store_true',
                        help='Do validation (True) or test (False) (default: False).')        
    parser.add_argument('--val-ratio', type=float, default=0.1,
                        help='Percentage of training samples used as validation (default: 0.1).')
    parser.add_argument('--eval-interval', type=int, default=10,
                        help='How often should the model be evaluated during training, unit in epochs (default: 10).')
    parser.add_argument('--dataset', type=str, default='CIFAR10',
                        choices=['MNIST', 'CIFAR10', 'CIFAR100'],
                        help='Which dataset to run on (default: CIFAR10).')  
    parser.add_argument('--dataroot', type=str, default='../data',
                        help='Where to retrieve data (default: ../data).')        
    parser.add_argument('--use-cuda', action='store_true',
                        help='Use CUDA (default: False).')
    parser.add_argument('--reproducible', action='store_true',
                        help='Ensure reproducibility (default: False).')
    parser.add_argument('--seed', type=int, default=0, metavar='S',
                        help='Random seed (default: 0).')

    parser.add_argument('--log-folder', type=str, default='../logs',
                        help='Where to store results.')

    return parser.parse_args()
