#!/bin/bash

# Extract the sd related metrics from vllm log files.
# We dont provide the log files since its contents violate Double-blind reviewing.
# python clean_logs.py

# Merge output csv files
python merge_csv.py --output ./csv_results_example_A800/summary/ \
    --prefill_input ./csv_results_example_A800/prefill/ \
    --ar_input ./csv_results_example_A800/ar/ \
    --sd_input ./csv_results_example_A800/sd/ \
    --sd_log ./csv_results_example_A800/summary/sd_log.csv

python merge_csv.py --output ./csv_results_example_H800/summary/ \
    --prefill_input ./csv_results_example_H800/prefill/ \
    --ar_input ./csv_results_example_H800/ar/ \
    --sd_input ./csv_results_example_H800/sd/ \
    --sd_log ./csv_results_example_H800/summary/sd_log.csv 

# Generate the plots for Fig 2 and the performance table for the paper
python gen_results.py --gpu A800 --output-dir plot_example --csv-path ./csv_results_example_A800/summary/summary.csv
python gen_results.py --gpu H800 --output-dir plot_example --csv-path ./csv_results_example_H800/summary/summary.csv