#!/bin/bash

# Extract the sd related metrics from vllm log files.
# We dont provide the log files since its contents violate Double-blind reviewing.
# python clean_logs.py

# Merge output csv files
python merge_csv.py --output ./csv_results_example/summary/ \
    --prefill_input ./csv_results_example/prefill/ \
    --ar_input ./csv_results_example/ar/ \
    --sd_input ./csv_results_example/sd/ \
    --sd_log ./csv_results_example/summary/sd_log.csv

# Generate the plots for Fig 2 and the performance table for the paper
python plot.py --dense-csv-path ./csv_results_example/summary/summary.csv \
    --moe-csv-path ../moe/csv_results_example_A800/summary/summary.csv \
    --output-dir plot_example