from Checker import Checker
from Modeling import ComputeSpeedup, residual
import argparse
import os


def main():
    parser = argparse.ArgumentParser(description="CSV Merger and Validator")
    parser.add_argument("--csv-path", default="../sparsity/csv_results/summary/summary.csv", help="The summary CSV file to be processed")
    parser.add_argument("--output-dir", default="./plot", help="The directory to save the plot")
    parser.add_argument("--target-model-path", default="../models/Qwen2-57B-A14B-Instruct", help="The model path of the target model")
    parser.add_argument("--draft-model-path", default="../models/Qwen2-0.5B-Instruct", help="The model path of the target model")

    args = parser.parse_args()

    checker = Checker(args.csv_path, args.target_model_path, args.draft_model_path)

    # Generate the figure 3 in the paper
    checker.plot(residual, ComputeSpeedup, args.output_dir)
    # Generate the results in the appendix
    checker.get_m_summary(residual, ComputeSpeedup, os.path.join(args.output_dir, "appendix"))



if __name__ == "__main__":
    main()