/*
 * Decompiled with CFR 0.152.
 */
import datastructures.DataSet;
import datastructures.DecisionTree;
import datastructures.FixedSizeArrayList;
import datastructures.MultiLinkedList;
import datastructures.NormalizedDataSet;
import datastructures.SetTrie;
import gurobi.GRB;
import gurobi.GRBEnv;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import lowerbounds.PairLBInitial;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010:\u001a\u0002022\u0006\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020\nH\u0002J\u0014\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0>H\u0002J\u0018\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020\n2\u0006\u0010B\u001a\u00020\nJ\n\u0010C\u001a\u0004\u0018\u00010@H\u0002J\u0012\u0010D\u001a\u0004\u0018\u00010@2\u0006\u0010B\u001a\u00020\nH\u0002J\u0012\u0010E\u001a\u0004\u0018\u00010@2\u0006\u0010B\u001a\u00020\nH\u0002J\u0012\u0010F\u001a\u0004\u0018\u00010@2\u0006\u0010G\u001a\u00020\nH\u0002J\u0018\u0010H\u001a\u00020I2\u0006\u0010;\u001a\u00020\b2\u0006\u0010J\u001a\u00020\nH\u0002J\u0018\u0010K\u001a\u00020I2\u0006\u0010L\u001a\u00020\u001a2\u0006\u0010M\u001a\u00020\nH\u0002J \u0010N\u001a\u0002022\u0006\u0010;\u001a\u00020\b2\u0006\u0010O\u001a\u00020\n2\u0006\u0010G\u001a\u00020\nH\u0002J\b\u0010P\u001a\u00020IH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\rR\u000e\u0010\u001d\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018R\u001e\u0010\"\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\rR\u001e\u0010$\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\rR\u001e\u0010&\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0018R\u001e\u0010(\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\rR\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010-\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\rR\u001e\u0010/\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\rR\u001a\u00101\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001e\u00107\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\rR\u000e\u00109\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"LWitnessTreeAlgo;", "", "data", "Ldatastructures/DataSet;", "algoType", "LAlgoType;", "(Ldatastructures/DataSet;LAlgoType;)V", "altW", "LWitnessTree;", "<set-?>", "", "cachingSearchTreeNodes", "getCachingSearchTreeNodes", "()I", "copiedSets", "getCopiedSets", "env", "Lgurobi/GRBEnv;", "firstDirtyExample", "greedyEffect", "getGreedyEffect", "", "greedyTime", "getGreedyTime", "()J", "leafsToCalculate", "Ldatastructures/FixedSizeArrayList;", "lowerBoundEffect", "getLowerBoundEffect", "mainW", "normData", "Ldatastructures/NormalizedDataSet;", "pairLBBadTime", "getPairLBBadTime", "pairLBCalculated", "getPairLBCalculated", "pairLBEffect", "getPairLBEffect", "pairLBGoodTime", "getPairLBGoodTime", "searchTreeNodes", "getSearchTreeNodes", "setTrie", "Ldatastructures/SetTrie;", "setTrieMaxSetSize", "setTrieSize", "getSetTrieSize", "subsetConstraintEffect", "getSubsetConstraintEffect", "timeoutHappened", "", "getTimeoutHappened", "()Z", "setTimeoutHappened", "(Z)V", "uniqueSets", "getUniqueSets", "word", "calcPairLB", "w", "curRemaining", "calcStartingPair", "Lkotlin/Pair;", "findTree", "Ldatastructures/DecisionTree;", "s", "upperBound", "findTreeStrategy1", "findTreeStrategy2", "findTreeStrategy3", "findTreeWithMaximumSize", "maxSize", "getWordFromLeaf", "", "leaf", "prepAltTree", "exampleList", "newWit", "refineTree", "curRoot", "resetInfoVariables", "Code"})
@SourceDebugExtension(value={"SMAP\nWitnessTreeAlgo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WitnessTreeAlgo.kt\nWitnessTreeAlgo\n+ 2 MultiLinkedList.kt\ndatastructures/MultiLinkedList\n*L\n1#1,367:1\n152#2,6:368\n152#2,6:374\n*S KotlinDebug\n*F\n+ 1 WitnessTreeAlgo.kt\nWitnessTreeAlgo\n*L\n358#1:368,6\n359#1:374,6\n*E\n"})
public final class WitnessTreeAlgo {
    @NotNull
    private final DataSet data;
    @NotNull
    private final AlgoType algoType;
    private int searchTreeNodes;
    private int lowerBoundEffect;
    private int subsetConstraintEffect;
    private int uniqueSets;
    private int setTrieSize;
    private int copiedSets;
    private int pairLBCalculated;
    private int pairLBEffect;
    private long pairLBGoodTime;
    private long pairLBBadTime;
    private int greedyEffect;
    private long greedyTime;
    private int cachingSearchTreeNodes;
    private boolean timeoutHappened;
    @NotNull
    private final GRBEnv env;
    @NotNull
    private final NormalizedDataSet normData;
    private WitnessTree mainW;
    private WitnessTree altW;
    private int firstDirtyExample;
    private final int setTrieMaxSetSize;
    @NotNull
    private final SetTrie setTrie;
    @NotNull
    private final FixedSizeArrayList word;
    private FixedSizeArrayList leafsToCalculate;

    public WitnessTreeAlgo(@NotNull DataSet data, @NotNull AlgoType algoType) {
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter((Object)algoType, "algoType");
        this.data = data;
        this.algoType = algoType;
        this.env = new GRBEnv();
        this.normData = this.algoType.getDoPreProcessing() ? this.data.reduceAndNormalize() : this.data.normalize();
        this.setTrieMaxSetSize = Math.min(this.normData.getN() / 4, 30);
        this.setTrie = new SetTrie();
        this.word = new FixedSizeArrayList(this.normData.getN());
        this.env.set(GRB.IntParam.Threads, 1);
        this.env.set(GRB.IntParam.OutputFlag, 0);
        this.env.set(GRB.IntParam.LogToConsole, 0);
        this.env.start();
    }

    public final int getSearchTreeNodes() {
        return this.searchTreeNodes;
    }

    public final int getLowerBoundEffect() {
        return this.lowerBoundEffect;
    }

    public final int getSubsetConstraintEffect() {
        return this.subsetConstraintEffect;
    }

    public final int getUniqueSets() {
        return this.uniqueSets;
    }

    public final int getSetTrieSize() {
        return this.setTrieSize;
    }

    public final int getCopiedSets() {
        return this.copiedSets;
    }

    public final int getPairLBCalculated() {
        return this.pairLBCalculated;
    }

    public final int getPairLBEffect() {
        return this.pairLBEffect;
    }

    public final long getPairLBGoodTime() {
        return this.pairLBGoodTime;
    }

    public final long getPairLBBadTime() {
        return this.pairLBBadTime;
    }

    public final int getGreedyEffect() {
        return this.greedyEffect;
    }

    public final long getGreedyTime() {
        return this.greedyTime;
    }

    public final int getCachingSearchTreeNodes() {
        return this.cachingSearchTreeNodes;
    }

    public final boolean getTimeoutHappened() {
        return this.timeoutHappened;
    }

    public final void setTimeoutHappened(boolean bl) {
        this.timeoutHappened = bl;
    }

    @Nullable
    public final DecisionTree findTree(int s, int upperBound) {
        this.resetInfoVariables();
        return switch (this.algoType.getStrategy()) {
            case 1 -> this.findTreeStrategy1();
            case 2 -> this.findTreeStrategy2(upperBound);
            case 3 -> this.findTreeStrategy3(upperBound);
            default -> this.findTreeWithMaximumSize(s);
        };
    }

    private final DecisionTree findTreeStrategy1() {
        int n;
        if (this.algoType.getUseLowerBounds()) {
            PairLBInitial pairLB = new PairLBInitial(this.env, this.normData);
            int bound = pairLB.calcLowerBound(0);
            pairLB.dispose();
            n = bound;
        } else {
            n = 1;
        }
        int lb = n;
        DecisionTree tree = null;
        int curMaxSize = lb;
        while (tree == null && !this.timeoutHappened) {
            System.out.println((Object)("Trying max size " + curMaxSize));
            tree = this.findTreeWithMaximumSize(curMaxSize);
            ++curMaxSize;
        }
        return tree;
    }

    private final DecisionTree findTreeStrategy2(int upperBound) {
        DecisionTree prevTree = null;
        DecisionTree tree = null;
        int curMaxSize = upperBound;
        do {
            System.out.println((Object)("Trying max size " + curMaxSize));
            prevTree = tree;
            tree = this.findTreeWithMaximumSize(curMaxSize);
            --curMaxSize;
        } while (tree != null && !this.timeoutHappened);
        return tree == null ? prevTree : null;
    }

    private final DecisionTree findTreeStrategy3(int upperBound) {
        int n;
        if (this.algoType.getUseLowerBounds()) {
            PairLBInitial pairLB = new PairLBInitial(this.env, this.normData);
            int bound = pairLB.calcLowerBound(0);
            pairLB.dispose();
            n = bound - 1;
        } else {
            n = 0;
        }
        int lb = n;
        int ub = upperBound;
        System.out.println((Object)("Trying max size " + ub));
        DecisionTree bestTree = this.findTreeWithMaximumSize(ub);
        while (ub - lb > 1 && !this.timeoutHappened) {
            int curMaxSize = lb + (ub - lb) / 2;
            System.out.println((Object)("Trying max size " + curMaxSize));
            DecisionTree tree = this.findTreeWithMaximumSize(curMaxSize);
            if (tree == null) {
                lb = curMaxSize;
                continue;
            }
            ub = curMaxSize;
            bestTree = tree;
        }
        return ub - lb > 1 || this.timeoutHappened ? null : bestTree;
    }

    private final DecisionTree findTreeWithMaximumSize(int maxSize) {
        DecisionTree decisionTree;
        WitnessTree witnessTree;
        int n;
        if (this.algoType.getUseDirtyPriority()) {
            int firstDirty;
            Pair<Integer, Integer> pair = this.calcStartingPair();
            int rootWit = ((Number)pair.component1()).intValue();
            this.firstDirtyExample = firstDirty = ((Number)pair.component2()).intValue();
            n = rootWit;
        } else {
            n = 0;
        }
        int rootWitness = n;
        this.mainW = new WitnessTree(this.normData, maxSize, this.algoType, true, this.env, rootWitness);
        this.altW = new WitnessTree(this.normData, maxSize, this.algoType, false, this.env, rootWitness);
        WitnessTree witnessTree2 = this.mainW;
        if (witnessTree2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mainW");
            witnessTree2 = null;
        }
        this.leafsToCalculate = new FixedSizeArrayList(witnessTree2.getMaxLeafCount());
        WitnessTree witnessTree3 = this.mainW;
        if (witnessTree3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mainW");
            witnessTree3 = null;
        }
        if ((witnessTree = this.mainW) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mainW");
            witnessTree = null;
        }
        boolean treeExists = this.refineTree(witnessTree3, witnessTree.getRoot(), maxSize);
        this.uniqueSets = this.setTrie.getWordsStored();
        this.setTrieSize = this.setTrie.getNumberOfNodes();
        if (treeExists) {
            WitnessTree witnessTree4 = this.mainW;
            if (witnessTree4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("mainW");
                witnessTree4 = null;
            }
            decisionTree = witnessTree4.getDecisionTree();
        } else {
            decisionTree = null;
        }
        return decisionTree;
    }

    private final boolean refineTree(WitnessTree w, int curRoot, int maxSize) {
        if (w.isMainTree()) {
            var4_4 = this.searchTreeNodes;
            this.searchTreeNodes = var4_4 + 1;
        } else {
            var4_4 = this.cachingSearchTreeNodes;
            this.cachingSearchTreeNodes = var4_4 + 1;
        }
        if (this.timeoutHappened) {
            return false;
        }
        int curRemaining = maxSize - w.getSize()[curRoot];
        if (w.isCorrectlyClassified()[curRoot]) {
            return true;
        }
        if (curRemaining <= 0) {
            return false;
        }
        if (this.algoType.getUseLowerBounds() && w.getImpLB().calcImpLowerBound(curRoot, curRemaining) > curRemaining) {
            int n = this.lowerBoundEffect;
            this.lowerBoundEffect = n + 1;
            return false;
        }
        if (this.algoType.getPairLBStrategy() > 0 && !this.algoType.getPairLBAfterCaching() && w.isMainTree() && w.getSize()[w.getRoot()] > 0 && w.getSize()[w.getRoot()] <= this.algoType.getPairLBMaxDepth() && !this.calcPairLB(w, curRemaining)) {
            return false;
        }
        if (this.algoType.getUseSubsetCaching() && w.isMainTree()) {
            FixedSizeArrayList fixedSizeArrayList = this.leafsToCalculate;
            if (fixedSizeArrayList == null) {
                Intrinsics.throwUninitializedPropertyAccessException("leafsToCalculate");
                fixedSizeArrayList = null;
            }
            fixedSizeArrayList.clear();
            int leaf = w.getMaxInnerCount();
            int n = w.getLastAddedLeaf();
            if (leaf <= n) {
                while (true) {
                    this.getWordFromLeaf(w, leaf);
                    Integer exists = this.setTrie.existsSubsetValue(this.word, curRemaining + 1, false);
                    if (exists != null) {
                        int n2 = this.copiedSets;
                        this.copiedSets = n2 + 1;
                        return false;
                    }
                    if (w.getLeafExampleCount(leaf) <= this.setTrieMaxSetSize) {
                        FixedSizeArrayList fixedSizeArrayList2 = this.leafsToCalculate;
                        if (fixedSizeArrayList2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("leafsToCalculate");
                            fixedSizeArrayList2 = null;
                        }
                        fixedSizeArrayList2.add(leaf);
                    }
                    if (leaf == n) break;
                    ++leaf;
                }
            }
        }
        if (this.algoType.getPairLBStrategy() > 0 && this.algoType.getPairLBAfterCaching() && w.isMainTree() && w.getSize()[w.getRoot()] > 0 && w.getSize()[w.getRoot()] <= this.algoType.getPairLBMaxDepth() && !this.calcPairLB(w, curRemaining)) {
            return false;
        }
        if (this.algoType.getUseSubsetCaching() && w.isMainTree()) {
            FixedSizeArrayList fixedSizeArrayList = this.leafsToCalculate;
            if (fixedSizeArrayList == null) {
                Intrinsics.throwUninitializedPropertyAccessException("leafsToCalculate");
                fixedSizeArrayList = null;
            }
            Iterator<Integer> leaf = fixedSizeArrayList.iterator();
            while (leaf.hasNext()) {
                boolean result;
                WitnessTree witnessTree;
                int leaf2 = ((Number)leaf.next()).intValue();
                this.getWordFromLeaf(w, leaf2);
                this.prepAltTree(this.word, this.word.get(0));
                WitnessTree witnessTree2 = this.altW;
                if (witnessTree2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("altW");
                    witnessTree2 = null;
                }
                if ((witnessTree = this.altW) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("altW");
                    witnessTree = null;
                }
                if (result = this.refineTree(witnessTree2, witnessTree.getRoot(), curRemaining)) continue;
                this.setTrie.insert(this.word, curRemaining + 1, false);
                return false;
            }
        }
        int e = !this.algoType.getUseDirtyPriority() || !w.isMainTree() || w.getSize()[w.getRoot()] != 0 ? w.getLowestDirtyExample(curRoot) : this.firstDirtyExample;
        boolean vChanged = false;
        boolean iChanged = false;
        int v = w.getLeafOf(e);
        while (v != -1) {
            vChanged = true;
            int n = this.normData.getD();
            block3: for (int dim = 0; dim < n; ++dim) {
                IntProgression intProgression;
                int value = this.normData.getValues()[e][dim];
                w.updateWitnessThresholds(v);
                if (value < w.getLeftWitThr()[dim][v]) {
                    intProgression = RangesKt.until(value, w.getLeftWitThr()[dim][v]);
                } else {
                    if (value <= w.getRightWitThr()[dim][v]) continue;
                    intProgression = RangesKt.downTo(value - 1, w.getRightWitThr()[dim][v]);
                }
                IntProgression thrRange = intProgression;
                iChanged = true;
                int thr = thrRange.getFirst();
                int n3 = thrRange.getLast();
                int n4 = thrRange.getStep();
                if ((n4 <= 0 || thr > n3) && (n4 >= 0 || n3 > thr)) continue;
                while (true) {
                    if (vChanged) {
                        w.refineTree(v, dim, thr, e);
                        vChanged = false;
                        iChanged = false;
                    } else if (iChanged) {
                        w.updateLastRefinement(dim, thr);
                        iChanged = false;
                    } else {
                        w.updateLastRefinement(thr);
                    }
                    if (this.algoType.getUseSubsetConstraints() && w.isASubsetConstraintBroken()) {
                        int n5 = this.subsetConstraintEffect;
                        this.subsetConstraintEffect = n5 + 1;
                        if (!w.isOnlyLastInnerThrConstraintBroken()) continue block3;
                    } else {
                        if (v == curRoot ? this.refineTree(w, w.getLastAddedInner(), maxSize) : this.refineTree(w, curRoot, maxSize)) {
                            return true;
                        }
                        if (this.timeoutHappened) {
                            return false;
                        }
                    }
                    if (thr == n3) continue block3;
                    thr += n4;
                }
            }
            if (!vChanged) {
                w.revertLastRefinement();
            }
            v = v != curRoot ? w.getParent()[v] : -1;
        }
        return false;
    }

    private final boolean calcPairLB(WitnessTree w, int curRemaining) {
        int n = this.pairLBCalculated;
        this.pairLBCalculated = n + 1;
        long t0 = System.currentTimeMillis();
        int greedy = w.getPairLB().calcGreedyLB();
        long t1 = System.currentTimeMillis();
        this.greedyTime += t1 - t0;
        if (greedy <= curRemaining) {
            int n2 = this.greedyEffect;
            this.greedyEffect = n2 + 1;
            return true;
        }
        if (w.getPairLB().calcLowerBound(curRemaining) > curRemaining) {
            int n3 = this.pairLBEffect;
            this.pairLBEffect = n3 + 1;
            long t2 = System.currentTimeMillis();
            this.pairLBGoodTime += t2 - t1;
            return false;
        }
        long t2 = System.currentTimeMillis();
        this.pairLBBadTime += t2 - t1;
        return true;
    }

    private final void resetInfoVariables() {
        this.timeoutHappened = false;
        this.searchTreeNodes = 0;
        this.lowerBoundEffect = 0;
        this.subsetConstraintEffect = 0;
        this.uniqueSets = 0;
        this.copiedSets = 0;
        this.setTrieSize = 0;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Integer, Integer> calcStartingPair() {
        int bestE1 = -1;
        int bestE2 = -1;
        int bestScore = Integer.MAX_VALUE;
        int n = this.normData.getN();
        for (int e1 = 0; e1 < n; ++e1) {
            if (!this.normData.getCla()[e1]) continue;
            int n2 = this.normData.getN();
            for (int e2 = 0; e2 < n2; ++e2) {
                if (this.normData.getCla()[e2]) continue;
                Iterable iterable = ArraysKt.getIndices(this.normData.getValues()[e1]);
                int n3 = 0;
                Iterator iterator2 = iterable.iterator();
                while (iterator2.hasNext()) {
                    void dim;
                    int n4;
                    int n5 = n4 = ((IntIterator)iterator2).nextInt();
                    int n6 = n3;
                    boolean bl = false;
                    int n7 = Math.abs(this.normData.getValues()[e1][dim] - this.normData.getValues()[e2][dim]);
                    n3 = n6 + n7;
                }
                int curScore = n3;
                if (curScore >= bestScore) continue;
                bestE1 = e1;
                bestE2 = e2;
                bestScore = curScore;
            }
        }
        return new Pair<Integer, Integer>(bestE1, bestE2);
    }

    private final void getWordFromLeaf(WitnessTree w, int leaf) {
        int e;
        MultiLinkedList this_$iv;
        this.word.clear();
        MultiLinkedList multiLinkedList = w.getELists();
        int list$iv = w.getDirtyList()[leaf];
        boolean $i$f$forEach = false;
        int nextElem$iv = this_$iv.getHead(list$iv);
        while (nextElem$iv != -1) {
            e = nextElem$iv;
            boolean bl = false;
            this.word.add(e);
            nextElem$iv = this_$iv.getNext(nextElem$iv);
        }
        this_$iv = w.getELists();
        list$iv = w.getNotDirtyList()[leaf];
        $i$f$forEach = false;
        nextElem$iv = this_$iv.getHead(list$iv);
        while (nextElem$iv != -1) {
            e = nextElem$iv;
            boolean bl = false;
            this.word.add(e);
            nextElem$iv = this_$iv.getNext(nextElem$iv);
        }
    }

    private final void prepAltTree(FixedSizeArrayList exampleList, int newWit) {
        WitnessTree witnessTree;
        WitnessTree witnessTree2 = this.mainW;
        if (witnessTree2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mainW");
            witnessTree2 = null;
        }
        if ((witnessTree = (this.altW = new WitnessTree(this.normData, witnessTree2.getMaxInnerCount(), this.algoType, false, this.env, newWit))) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("altW");
            witnessTree = null;
        }
        witnessTree.reduceExamplesToSubset(exampleList);
    }
}

