/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.DataSet;
import datastructures.DataType;
import datastructures.DecisionTree;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a.\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\f\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u001a9\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0016\u001aA\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019\u001a\u0016\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u001c"}, d2={"exportDataForWeka", "", "outputDirectoryPath", "", "data", "Ldatastructures/DataSet;", "name", "subsetRatio", "", "subsetSeed", "", "exportDataForYaDT", "exportDataToFile", "generateRandomData", "n", "dLower", "", "dUpper", "dTypes", "", "Ldatastructures/DataType;", "seed", "(I[D[D[Ldatastructures/DataType;I)Ldatastructures/DataSet;", "t", "Ldatastructures/DecisionTree;", "(I[D[D[Ldatastructures/DataType;ILdatastructures/DecisionTree;)Ldatastructures/DataSet;", "importDataFromFile", "dataDirectoryPath", "Code"})
public final class DataSetKt {
    @NotNull
    public static final DataSet generateRandomData(int n, @NotNull double[] dLower, @NotNull double[] dUpper, @NotNull DataType[] dTypes, int seed) {
        double[][] dArrayArray;
        int n2;
        int n3;
        Intrinsics.checkNotNullParameter(dLower, "dLower");
        Intrinsics.checkNotNullParameter(dUpper, "dUpper");
        Intrinsics.checkNotNullParameter(dTypes, "dTypes");
        Random r = RandomKt.Random(seed);
        int d = dLower.length;
        Object object = new double[n][];
        int n4 = d;
        int n5 = n;
        for (n3 = 0; n3 < n; ++n3) {
            n2 = n3;
            double[] dArray = new double[d];
            int n6 = n2;
            dArrayArray = object;
            for (int i = 0; i < d; ++i) {
                int n7 = i;
                dArray[n7] = switch (WhenMappings.$EnumSwitchMapping$0[dTypes[n7].ordinal()]) {
                    case 1 -> r.nextDouble(dLower[n7], dUpper[n7]);
                    case 2 -> r.nextInt((int)dLower[n7], (int)dUpper[n7]);
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
            dArrayArray[n6] = dArray;
        }
        double[][] dArrayArray2 = object;
        n3 = 0;
        object = new boolean[n];
        dArrayArray = dArrayArray2;
        while (n3 < n) {
            n2 = n3++;
            object[n2] = (double[])r.nextBoolean();
        }
        Object object2 = object;
        double[][] dArrayArray3 = dArrayArray;
        int n8 = n4;
        int n9 = n5;
        return new DataSet(n9, n8, dArrayArray3, (boolean[])object2);
    }

    @NotNull
    public static final DataSet generateRandomData(int n, @NotNull double[] dLower, @NotNull double[] dUpper, @NotNull DataType[] dTypes, int seed, @NotNull DecisionTree t) {
        Intrinsics.checkNotNullParameter(dLower, "dLower");
        Intrinsics.checkNotNullParameter(dUpper, "dUpper");
        Intrinsics.checkNotNullParameter(dTypes, "dTypes");
        Intrinsics.checkNotNullParameter(t, "t");
        Random r = RandomKt.Random(seed);
        int d = dLower.length;
        int n2 = 0;
        double[][] dArrayArray = new double[n][];
        int n3 = d;
        int n4 = n;
        while (n2 < n) {
            int n5 = n2++;
            dArrayArray[n5] = new double[d];
        }
        boolean[] blArray = new boolean[n];
        double[][] dArrayArray2 = dArrayArray;
        int n6 = n3;
        int n7 = n4;
        DataSet data = new DataSet(n7, n6, dArrayArray2, blArray);
        for (int e = 0; e < n; ++e) {
            int dim;
            int curRoot = t.getRoot();
            double[] lo = (double[])dLower.clone();
            double[] up = (double[])dUpper.clone();
            while (!t.isLeaf(curRoot)) {
                dim = t.getDim()[curRoot];
                if (r.nextBoolean()) {
                    up[dim] = Math.min(up[dim], t.getThr()[curRoot]);
                    curRoot = t.getLeftChild()[curRoot];
                    continue;
                }
                lo[dim] = Math.max(lo[dim], t.getThr()[curRoot]);
                curRoot = t.getRightChild()[curRoot];
            }
            for (dim = 0; dim < d; ++dim) {
                double[] dArray = data.getValues()[e];
                dArray[dim] = switch (WhenMappings.$EnumSwitchMapping$0[dTypes[dim].ordinal()]) {
                    case 1 -> -r.nextDouble(-up[dim], -lo[dim]);
                    case 2 -> -((double)r.nextInt(-((int)up[dim]), -((int)lo[dim])));
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
            data.getCla()[e] = t.getCla()[curRoot];
        }
        return data;
    }

    public static final void exportDataToFile(@NotNull DataSet data, @NotNull String name) {
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(name, "name");
        PrintStream out = new PrintStream(new File("../Daten/" + name + ".csv"));
        int i = 1;
        int n = data.getD();
        if (i <= n) {
            while (true) {
                out.print(i + ",");
                if (i == n) break;
                ++i;
            }
        }
        out.println("x");
        n = data.getN();
        for (int e = 0; e < n; ++e) {
            int n2 = data.getD();
            for (int i2 = 0; i2 < n2; ++i2) {
                if ((double)((int)data.getValues()[e][i2]) == data.getValues()[e][i2]) {
                    out.print((int)data.getValues()[e][i2] + ",");
                    continue;
                }
                out.print(data.getValues()[e][i2] + ",");
            }
            out.println(data.getCla()[e] ? "1" : "0");
        }
        out.close();
    }

    @NotNull
    public static final DataSet importDataFromFile(@NotNull String dataDirectoryPath, @NotNull String name) {
        Intrinsics.checkNotNullParameter(dataDirectoryPath, "dataDirectoryPath");
        Intrinsics.checkNotNullParameter(name, "name");
        File file = new File(dataDirectoryPath + "/" + name);
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        LinkedList<String> lines = new LinkedList<String>();
        TextStreamsKt.forEachLine(br, (Function1<? super String, Unit>)new Function1<String, Unit>(lines){
            final /* synthetic */ LinkedList<String> $lines;
            {
                this.$lines = $lines;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.$lines.add(it);
            }
        });
        lines.removeFirst();
        int n = lines.size();
        String string = lines.getFirst();
        Intrinsics.checkNotNullExpressionValue(string, "getFirst(...)");
        String[] stringArray = new String[]{","};
        int d = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null).size() - 1;
        int n2 = 0;
        double[][] dArrayArray = new double[n][];
        int n3 = d;
        int n4 = n;
        while (n2 < n) {
            int n5 = n2++;
            dArrayArray[n5] = new double[d];
        }
        boolean[] blArray = new boolean[n];
        double[][] dArrayArray2 = dArrayArray;
        int n6 = n3;
        int n7 = n4;
        DataSet data = new DataSet(n7, n6, dArrayArray2, blArray);
        Iterator iterator2 = lines.iterator();
        int n8 = 0;
        while (iterator2.hasNext()) {
            int e = n8++;
            String line = (String)iterator2.next();
            String[] stringArray2 = new String[]{","};
            List splits = StringsKt.split$default((CharSequence)line, stringArray2, false, 0, 6, null);
            int n9 = splits.size() - 1;
            for (int i = 0; i < n9; ++i) {
                data.getValues()[e][i] = Double.parseDouble((String)splits.get(i));
            }
            data.getCla()[e] = Integer.parseInt((String)splits.get(splits.size() - 1)) == 1;
        }
        return data;
    }

    public static final void exportDataForYaDT(@NotNull String outputDirectoryPath, @NotNull DataSet data, @NotNull String name, float subsetRatio, int subsetSeed) {
        int n;
        Intrinsics.checkNotNullParameter(outputDirectoryPath, "outputDirectoryPath");
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(name, "name");
        Pair<DataSet, DataSet> pair = data.randomSubset((int)((float)data.getN() * subsetRatio), subsetSeed);
        DataSet trainingData = pair.component1();
        DataSet testData = pair.component2();
        String fullName = name + "_" + subsetRatio + "_" + subsetSeed;
        File namesFile = new File(outputDirectoryPath + "/" + fullName + ".names");
        PrintStream namesOut = new PrintStream(namesFile);
        int i = 1;
        int n2 = data.getD();
        if (i <= n2) {
            while (true) {
                namesOut.println(i + ",float,continuous");
                if (i == n2) break;
                ++i;
            }
        }
        namesOut.print("class,integer,class");
        namesOut.close();
        File dataFile = new File(outputDirectoryPath + "/" + fullName + ".data");
        PrintStream dataOut = new PrintStream(dataFile);
        int n3 = trainingData.getN();
        for (int e = 0; e < n3; ++e) {
            n = trainingData.getD();
            for (int i2 = 0; i2 < n; ++i2) {
                if ((double)((int)trainingData.getValues()[e][i2]) == trainingData.getValues()[e][i2]) {
                    dataOut.print((int)trainingData.getValues()[e][i2] + ",");
                    continue;
                }
                dataOut.print(trainingData.getValues()[e][i2] + ",");
            }
            dataOut.print(trainingData.getCla()[e] ? "1" : "0");
            if (e >= trainingData.getN() - 1) continue;
            dataOut.println();
        }
        File testFile = new File(outputDirectoryPath + "/" + fullName + ".test");
        PrintStream testOut = new PrintStream(testFile);
        n = testData.getN();
        for (int e = 0; e < n; ++e) {
            int n4 = testData.getD();
            for (int i3 = 0; i3 < n4; ++i3) {
                if ((double)((int)testData.getValues()[e][i3]) == testData.getValues()[e][i3]) {
                    testOut.print((int)testData.getValues()[e][i3] + ",");
                    continue;
                }
                testOut.print(testData.getValues()[e][i3] + ",");
            }
            testOut.print(testData.getCla()[e] ? "1" : "0");
            if (e >= testData.getN() - 1) continue;
            testOut.println();
        }
    }

    public static final void exportDataForWeka(@NotNull String outputDirectoryPath, @NotNull DataSet data, @NotNull String name, float subsetRatio, int subsetSeed) {
        int i;
        int n;
        Intrinsics.checkNotNullParameter(outputDirectoryPath, "outputDirectoryPath");
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(name, "name");
        Pair<DataSet, DataSet> pair = data.randomSubset((int)((float)data.getN() * subsetRatio), subsetSeed);
        DataSet trainingData = pair.component1();
        DataSet testData = pair.component2();
        String fullName = name + "_" + subsetRatio + "_" + subsetSeed;
        File dataFile = new File(outputDirectoryPath + "/" + fullName + "_data.arff");
        PrintStream dataOut = new PrintStream(dataFile);
        dataOut.println("@relation " + fullName);
        int i2 = 1;
        int n2 = trainingData.getD();
        if (i2 <= n2) {
            while (true) {
                dataOut.println("@attribute d" + i2 + " real");
                if (i2 == n2) break;
                ++i2;
            }
        }
        dataOut.println("@attribute class {1, 0}");
        dataOut.println("@data");
        n2 = trainingData.getN();
        for (int e = 0; e < n2; ++e) {
            n = trainingData.getD();
            for (i = 0; i < n; ++i) {
                if ((double)((int)trainingData.getValues()[e][i]) == trainingData.getValues()[e][i]) {
                    dataOut.print((int)trainingData.getValues()[e][i] + ",");
                    continue;
                }
                dataOut.print(trainingData.getValues()[e][i] + ",");
            }
            dataOut.print(trainingData.getCla()[e] ? "1" : "0");
            if (e >= trainingData.getN() - 1) continue;
            dataOut.println();
        }
        dataOut.close();
        File testFile = new File(outputDirectoryPath + "/" + fullName + "_test.arff");
        PrintStream testOut = new PrintStream(testFile);
        testOut.println("@relation " + fullName);
        i = 1;
        n = testData.getD();
        if (i <= n) {
            while (true) {
                testOut.println("@attribute d" + i + " real");
                if (i == n) break;
                ++i;
            }
        }
        testOut.println("@attribute class {1, 0}");
        testOut.println("@data");
        n = testData.getN();
        for (int e = 0; e < n; ++e) {
            int n3 = testData.getD();
            for (int i3 = 0; i3 < n3; ++i3) {
                if ((double)((int)testData.getValues()[e][i3]) == testData.getValues()[e][i3]) {
                    testOut.print((int)testData.getValues()[e][i3] + ",");
                    continue;
                }
                testOut.print(testData.getValues()[e][i3] + ",");
            }
            testOut.print(testData.getCla()[e] ? "1" : "0");
            if (e >= testData.getN() - 1) continue;
            testOut.println();
        }
        testOut.close();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataType.values().length];
            try {
                nArray[DataType.REAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.INTEGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

