/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.FixedSizeArrayList;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u0011J3\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00042\n\u0010\u0017\u001a\u00060\nR\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0019J'\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u001cJ3\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00042\n\u0010\u0017\u001a\u00060\nR\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0019J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\""}, d2={"Ldatastructures/SetTrie;", "", "()V", "curBestValue", "", "<set-?>", "numberOfNodes", "getNumberOfNodes", "()I", "root", "Ldatastructures/SetTrie$Node;", "wordsStored", "getWordsStored", "exists", "word", "Ldatastructures/FixedSizeArrayList;", "presorted", "", "(Ldatastructures/FixedSizeArrayList;Z)Ljava/lang/Integer;", "existsSubset", "existsSubsetBestValue", "maxValue", "existsSubsetBestValueRecurse", "curNode", "curIndex", "(Ldatastructures/FixedSizeArrayList;ILdatastructures/SetTrie$Node;I)Ljava/lang/Integer;", "existsSubsetValue", "minValue", "(Ldatastructures/FixedSizeArrayList;IZ)Ljava/lang/Integer;", "existsSubsetValueRecurse", "insert", "", "value", "Node", "Code"})
public final class SetTrie {
    private int wordsStored;
    private int numberOfNodes = 1;
    @NotNull
    private final Node root = new Node(-1);
    private int curBestValue;

    public final int getWordsStored() {
        return this.wordsStored;
    }

    public final int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public final void insert(@NotNull FixedSizeArrayList word, int value, boolean presorted) {
        Intrinsics.checkNotNullParameter(word, "word");
        if (!presorted) {
            word.sort();
        }
        Node curNode = this.root;
        int curLabel = 0;
        for (int i = 0; i < word.size(); ++i) {
            curNode.setMaxValue(Math.max(curNode.getMaxValue(), value));
            curLabel = word.get(i);
            curNode = curNode.hasChildLabeled(curLabel) ? curNode.get(curLabel) : curNode.createChild(curLabel);
        }
        if (!curNode.isEnd()) {
            curNode.setEnd(true);
            int n = this.wordsStored;
            this.wordsStored = n + 1;
        }
        curNode.setValue(value);
        curNode.setMaxValue(Math.max(curNode.getMaxValue(), value));
    }

    public static /* synthetic */ void insert$default(SetTrie setTrie, FixedSizeArrayList fixedSizeArrayList, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        setTrie.insert(fixedSizeArrayList, n, bl);
    }

    @Nullable
    public final Integer exists(@NotNull FixedSizeArrayList word, boolean presorted) {
        Intrinsics.checkNotNullParameter(word, "word");
        if (!presorted) {
            word.sort();
        }
        Node curNode = this.root;
        int curLabel = 0;
        for (int i = 0; i < word.size(); ++i) {
            curLabel = word.get(i);
            if (!curNode.hasChildLabeled(curLabel)) {
                return null;
            }
            curNode = curNode.get(curLabel);
        }
        return curNode.isEnd() ? Integer.valueOf(curNode.getValue()) : null;
    }

    public static /* synthetic */ Integer exists$default(SetTrie setTrie, FixedSizeArrayList fixedSizeArrayList, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return setTrie.exists(fixedSizeArrayList, bl);
    }

    @Nullable
    public final Integer existsSubset(@NotNull FixedSizeArrayList word, boolean presorted) {
        Intrinsics.checkNotNullParameter(word, "word");
        if (!presorted) {
            word.sort();
        }
        return this.existsSubsetValueRecurse(word, -1, this.root, 0);
    }

    public static /* synthetic */ Integer existsSubset$default(SetTrie setTrie, FixedSizeArrayList fixedSizeArrayList, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return setTrie.existsSubset(fixedSizeArrayList, bl);
    }

    @Nullable
    public final Integer existsSubsetValue(@NotNull FixedSizeArrayList word, int minValue, boolean presorted) {
        Intrinsics.checkNotNullParameter(word, "word");
        if (!presorted) {
            word.sort();
        }
        return this.existsSubsetValueRecurse(word, minValue, this.root, 0);
    }

    public static /* synthetic */ Integer existsSubsetValue$default(SetTrie setTrie, FixedSizeArrayList fixedSizeArrayList, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return setTrie.existsSubsetValue(fixedSizeArrayList, n, bl);
    }

    private final Integer existsSubsetValueRecurse(FixedSizeArrayList word, int minValue, Node curNode, int curIndex) {
        Integer recurse;
        if (curNode.isEnd() && curNode.getValue() >= minValue) {
            return curNode.getValue();
        }
        if (curIndex == word.size()) {
            return null;
        }
        if (curNode.getMaxValue() < minValue) {
            return null;
        }
        int curLabel = word.get(curIndex);
        if (curNode.hasChildLabeled(curLabel) && (recurse = this.existsSubsetValueRecurse(word, minValue, curNode.get(curLabel), curIndex + 1)) != null) {
            return recurse;
        }
        return this.existsSubsetValueRecurse(word, minValue, curNode, curIndex + 1);
    }

    public final int existsSubsetBestValue(@NotNull FixedSizeArrayList word, int maxValue, boolean presorted) {
        Intrinsics.checkNotNullParameter(word, "word");
        if (!presorted) {
            word.sort();
        }
        this.curBestValue = 0;
        this.existsSubsetBestValueRecurse(word, maxValue, this.root, 0);
        return this.curBestValue;
    }

    public static /* synthetic */ int existsSubsetBestValue$default(SetTrie setTrie, FixedSizeArrayList fixedSizeArrayList, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return setTrie.existsSubsetBestValue(fixedSizeArrayList, n, bl);
    }

    private final Integer existsSubsetBestValueRecurse(FixedSizeArrayList word, int maxValue, Node curNode, int curIndex) {
        Integer recurse;
        if (curNode.isEnd() && curNode.getValue() > this.curBestValue) {
            this.curBestValue = curNode.getValue();
        }
        if (this.curBestValue >= maxValue) {
            return this.curBestValue;
        }
        if (curIndex == word.size()) {
            return null;
        }
        if (curNode.getMaxValue() <= this.curBestValue) {
            return null;
        }
        int curLabel = word.get(curIndex);
        if (curNode.hasChildLabeled(curLabel) && (recurse = this.existsSubsetBestValueRecurse(word, maxValue, curNode.get(curLabel), curIndex + 1)) != null) {
            return recurse;
        }
        return this.existsSubsetBestValueRecurse(word, maxValue, curNode, curIndex + 1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0019\u001a\u00060\u0000R\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003J\u0015\u0010\u001a\u001a\u00060\u0000R\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR5\u0010\f\u001a&\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\u0000R\u00020\u000e0\rj\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\u0000R\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000b\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\u0015\u00a8\u0006\u001c"}, d2={"Ldatastructures/SetTrie$Node;", "", "label", "", "(Ldatastructures/SetTrie;I)V", "isEnd", "", "()Z", "setEnd", "(Z)V", "getLabel", "()I", "map", "Ljava/util/HashMap;", "Ldatastructures/SetTrie;", "Lkotlin/collections/HashMap;", "getMap", "()Ljava/util/HashMap;", "maxValue", "getMaxValue", "setMaxValue", "(I)V", "value", "getValue", "setValue", "createChild", "get", "hasChildLabeled", "Code"})
    private final class Node {
        private final int label;
        @NotNull
        private final HashMap<Integer, Node> map;
        private boolean isEnd;
        private int value;
        private int maxValue;

        public Node(int label) {
            this.label = label;
            this.map = new HashMap();
            this.value = -1;
            this.maxValue = -1;
        }

        public final int getLabel() {
            return this.label;
        }

        @NotNull
        public final HashMap<Integer, Node> getMap() {
            return this.map;
        }

        public final boolean isEnd() {
            return this.isEnd;
        }

        public final void setEnd(boolean bl) {
            this.isEnd = bl;
        }

        public final int getValue() {
            return this.value;
        }

        public final void setValue(int n) {
            this.value = n;
        }

        public final int getMaxValue() {
            return this.maxValue;
        }

        public final void setMaxValue(int n) {
            this.maxValue = n;
        }

        public final boolean hasChildLabeled(int label) {
            return this.map.containsKey(label);
        }

        @NotNull
        public final Node createChild(int label) {
            if (!this.hasChildLabeled(label)) {
                Integer n = label;
                ((Map)this.map).put(n, new Node(label));
                SetTrie setTrie = SetTrie.this;
                int n2 = setTrie.getNumberOfNodes();
                setTrie.numberOfNodes = n2 + 1;
            }
            return this.get(label);
        }

        @NotNull
        public final Node get(int label) {
            return (Node)MapsKt.getValue((Map)this.map, label);
        }
    }
}

