/*
 * Decompiled with CFR 0.152.
 */
package gurobi;

import gurobi.GRBException;
import gurobi.GRBLinExpr;
import gurobi.GRBVar;
import gurobi.GurobiJni;

public abstract class GRBCallback {
    private long model;
    private int cols;
    private long cbdata;
    private double[] x;
    private double[] newx;
    private double[] relx;
    protected int where;

    protected abstract void callback();

    void setandcall(long xmodel, int xcols, long xcbdata, int xwhere) throws GRBException {
        this.model = xmodel;
        this.cols = xcols;
        this.cbdata = xcbdata;
        this.where = xwhere;
        this.callback();
        if (this.newx != null) {
            this.useSolution();
        }
        this.x = null;
        this.relx = null;
    }

    protected void finalize() {
    }

    protected double getDoubleInfo(int what) throws GRBException {
        double[] val = new double[1];
        int error = GurobiJni.cbgetdblinfo(this.cbdata, this.where, what, val);
        if (error != 0) {
            throw new GRBException(error);
        }
        return val[0];
    }

    protected int getIntInfo(int what) throws GRBException {
        int[] val = new int[1];
        int error = GurobiJni.cbgetintinfo(this.cbdata, this.where, what, val);
        if (error != 0) {
            throw new GRBException(error);
        }
        return val[0];
    }

    protected String getStringInfo(int what) throws GRBException {
        assert (this.where == 6 && what == 6001);
        return GurobiJni.cbgetstrinfo(this.cbdata, this.where, what);
    }

    protected double getSolution(GRBVar v) throws GRBException {
        int col;
        if (this.where != 4 && this.where != 8) {
            throw new GRBException("where != GRB.CB_MIPSOL", 10011);
        }
        if (this.x == null) {
            this.x = new double[this.cols];
            int error = this.where == 4 ? GurobiJni.cbgetdblinfo(this.cbdata, this.where, 4001, this.x) : GurobiJni.cbgetdblinfo(this.cbdata, this.where, 8003, this.x);
            if (error != 0) {
                throw new GRBException("Error in callback", error);
            }
        }
        if ((col = v.getcolno()) < 0 || col >= this.cols) {
            throw new GRBException("Not in the model", 20001);
        }
        return this.x[col];
    }

    protected double[] getSolution(GRBVar[] xvars) throws GRBException {
        if (this.where != 4 && this.where != 8) {
            throw new GRBException("where != GRB.CB_MIPSOL", 10011);
        }
        if (xvars == null || xvars.length == 0) {
            return null;
        }
        if (this.x == null) {
            this.x = new double[this.cols];
            int error = this.where == 4 ? GurobiJni.cbgetdblinfo(this.cbdata, this.where, 4001, this.x) : GurobiJni.cbgetdblinfo(this.cbdata, this.where, 8003, this.x);
            if (error != 0) {
                throw new GRBException("Error in callback", error);
            }
        }
        double[] sol = new double[xvars.length];
        for (int i = 0; i < xvars.length; ++i) {
            int col = xvars[i].getcolno();
            if (col < 0 || col >= this.cols) {
                throw new GRBException("Not in the model", 20001);
            }
            sol[i] = this.x[col];
        }
        return sol;
    }

    protected double[][] getSolution(GRBVar[][] xvars) throws GRBException {
        if (this.where != 4 && this.where != 8) {
            throw new GRBException("where != GRB.CB_MIPSOL", 10011);
        }
        if (xvars == null || xvars.length == 0) {
            return null;
        }
        if (this.x == null) {
            this.x = new double[this.cols];
            int error = this.where == 4 ? GurobiJni.cbgetdblinfo(this.cbdata, this.where, 4001, this.x) : GurobiJni.cbgetdblinfo(this.cbdata, this.where, 8003, this.x);
            if (error != 0) {
                throw new GRBException("Error in callback", error);
            }
        }
        double[][] sol = new double[xvars.length][xvars[0].length];
        for (int i = 0; i < xvars.length; ++i) {
            for (int j = 0; j < xvars[0].length; ++j) {
                int col = xvars[i][j].getcolno();
                if (col < 0 || col >= this.cols) {
                    throw new GRBException("Not in the model", 20001);
                }
                sol[i][j] = this.x[col];
            }
        }
        return sol;
    }

    protected double getNodeRel(GRBVar v) throws GRBException {
        int col;
        if (this.where != 5) {
            throw new GRBException("where != GRB.CB_MIPNODE", 10011);
        }
        if (this.relx == null) {
            this.relx = new double[this.cols];
            int error = GurobiJni.cbgetdblinfo(this.cbdata, this.where, 5002, this.relx);
            if (error != 0) {
                throw new GRBException("Error in callback", error);
            }
        }
        if ((col = v.getcolno()) < 0 || col >= this.cols) {
            throw new GRBException("Not in the model", 20001);
        }
        return this.relx[col];
    }

    protected double[] getNodeRel(GRBVar[] xvars) throws GRBException {
        if (this.where != 5) {
            throw new GRBException("where != GRB.CB_MIPNODE", 10011);
        }
        if (xvars == null || xvars.length == 0) {
            return null;
        }
        if (this.relx == null) {
            this.relx = new double[this.cols];
            int error = GurobiJni.cbgetdblinfo(this.cbdata, this.where, 5002, this.relx);
            if (error != 0) {
                throw new GRBException("Error in callback", error);
            }
        }
        double[] sol = new double[xvars.length];
        for (int i = 0; i < xvars.length; ++i) {
            int col = xvars[i].getcolno();
            if (col < 0 || col >= this.cols) {
                throw new GRBException("Not in the model", 20001);
            }
            sol[i] = this.relx[col];
        }
        return sol;
    }

    protected double[][] getNodeRel(GRBVar[][] xvars) throws GRBException {
        if (this.where != 5) {
            throw new GRBException("where != GRB.CB_MIPNODE", 10011);
        }
        if (xvars == null || xvars.length == 0) {
            return null;
        }
        if (this.relx == null) {
            this.relx = new double[this.cols];
            int error = GurobiJni.cbgetdblinfo(this.cbdata, this.where, 5002, this.relx);
            if (error != 0) {
                throw new GRBException("Error in callback", error);
            }
        }
        double[][] sol = new double[xvars.length][xvars[0].length];
        for (int i = 0; i < xvars.length; ++i) {
            for (int j = 0; j < xvars[0].length; ++j) {
                int col = xvars[i][j].getcolno();
                if (col < 0 || col >= this.cols) {
                    throw new GRBException("Not in the model", 20001);
                }
                sol[i][j] = this.relx[col];
            }
        }
        return sol;
    }

    protected void setSolution(GRBVar v, double val) throws GRBException {
        int col;
        if (this.where != 3 && this.where != 5 && this.where != 4) {
            throw new GRBException("where != GRB.CB_MIP && where != GRB.CB_MIPNODE && where != GRB.CB_MIPSOL", 10011);
        }
        if (this.newx == null) {
            this.newx = new double[this.cols];
            for (int j = 0; j < this.cols; ++j) {
                this.newx[j] = 1.0E101;
            }
        }
        if ((col = v.getcolno()) < 0 || col >= this.cols) {
            throw new GRBException("Not in the model", 20001);
        }
        this.newx[col] = val;
    }

    protected void setSolution(GRBVar[] xvars, double[] sol) throws GRBException {
        if (this.where != 3 && this.where != 5 && this.where != 4) {
            throw new GRBException("where != GRB.CB_MIP && where != GRB.CB_MIPNODE && where != GRB.CB_MIPSOL", 10011);
        }
        if (xvars == null || xvars.length == 0) {
            return;
        }
        int len = xvars.length;
        if (sol.length < len) {
            len = sol.length;
        }
        if (this.newx == null) {
            this.newx = new double[this.cols];
            for (int j = 0; j < this.cols; ++j) {
                this.newx[j] = 1.0E101;
            }
        }
        for (int i = 0; i < len; ++i) {
            int col = xvars[i].getcolno();
            if (col < 0 || col >= this.cols) {
                throw new GRBException("Not in the model", 20001);
            }
            this.newx[col] = sol[i];
        }
    }

    protected double useSolution() throws GRBException {
        if (this.where != 3 && this.where != 5 && this.where != 4) {
            throw new GRBException("where != GRB.CB_MIP && where != GRB.CB_MIPNODE && where != GRB.CB_MIPSOL", 10011);
        }
        double[] obj = new double[]{1.0E100};
        if (this.newx != null) {
            double[] tmpx = this.newx;
            this.newx = null;
            int error = GurobiJni.cbsolution(this.cbdata, tmpx, obj);
            if (error != 0) {
                throw new GRBException("Error in Callback", error);
            }
        }
        return obj[0];
    }

    protected void addCut(GRBLinExpr expr, char sense, double rhs) throws GRBException {
        this.addCutOrLazy(expr, sense, rhs, 1);
    }

    protected void addLazy(GRBLinExpr expr, char sense, double rhs) throws GRBException {
        this.addCutOrLazy(expr, sense, rhs, 0);
    }

    private void addCutOrLazy(GRBLinExpr expr, char sense, double rhs, int iscut) throws GRBException {
        int k;
        GRBVar v;
        int i;
        if (this.where != 5 && this.where != 4) {
            throw new GRBException("where != GRB.CB_MIPNODE && where != GRB.CB_MIPSOL", 10011);
        }
        int nz = expr.size();
        double xrhs = rhs - expr.getConstant();
        int[] ind = new int[nz];
        double[] val = new double[nz];
        for (i = 0; i < nz; ++i) {
            v = expr.getVar(i);
            k = v.getcolno();
            if (k >= 0 && k < this.cols) continue;
            throw new GRBException("Not in the model", 20001);
        }
        nz = 0;
        for (i = 0; i < expr.size(); ++i) {
            v = expr.getVar(i);
            ind[nz] = k = v.getcolno();
            val[nz] = expr.getCoeff(i);
            ++nz;
        }
        int[] tmp = new int[]{nz};
        GurobiJni.clean2(tmp, ind, val);
        nz = tmp[0];
        int error = GurobiJni.cbcutorlazy(this.cbdata, nz, xrhs, ind, val, sense, iscut);
        if (error != 0) {
            if (iscut == 1) {
                throw new GRBException("In addCut", error);
            }
            throw new GRBException("In addLazy", error);
        }
    }

    protected void abort() {
        GurobiJni.terminate(this.model);
    }

    public void proceed() throws GRBException {
        int error = GurobiJni.proceed(this.cbdata);
        if (error != 0) {
            throw new GRBException("Error calling proceed", 10011);
        }
    }

    protected void stopOneMultiObj(int objnum) throws GRBException {
        int error = GurobiJni.stoponemultiobj(this.model, this.cbdata, objnum);
        if (error != 0) {
            throw new GRBException("Error calling stopOneMultiObj", 10011);
        }
    }
}

