/*
 * Decompiled with CFR 0.152.
 */
package gurobi;

import gurobi.GRB;
import gurobi.GRBCObj;
import gurobi.GRBException;
import gurobi.GurobiJni;

public class GRBGenConstr {
    private GRBCObj Cmodel = null;
    private long model;
    private int num;

    GRBGenConstr() {
        this.num = -2;
        this.model = 0L;
    }

    GRBGenConstr(GRBCObj XCmodel, int genc) {
        this.Cmodel = XCmodel;
        this.model = XCmodel.get();
        this.num = genc;
    }

    protected void finalize() {
    }

    void setindex(int genc) {
        this.num = genc;
    }

    int getindex() {
        return this.num;
    }

    public int get(GRB.IntAttr attr) throws GRBException {
        if (this.num < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 5);
        if (error != 0) {
            throw new GRBException("Not a general constraint attribute", error);
        }
        int[] ind = new int[1];
        int[] value = new int[1];
        error = GurobiJni.getintattrlist(this.model, attr.toString(), this.num, 0, ind, value);
        if (error != 0) {
            throw new GRBException("Error at GRBGenConstr.get", error);
        }
        return value[0];
    }

    public double get(GRB.DoubleAttr attr) throws GRBException {
        if (this.num < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 5);
        if (error != 0) {
            throw new GRBException("Not a general constraint attribute", error);
        }
        int[] ind = new int[1];
        double[] value = new double[1];
        error = GurobiJni.getdblattrlist(this.model, attr.toString(), this.num, 0, ind, value);
        if (error != 0) {
            throw new GRBException("Error at GRBGenConstr.get", error);
        }
        return value[0];
    }

    public String get(GRB.StringAttr attr) throws GRBException {
        if (this.num < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 5);
        if (error != 0) {
            throw new GRBException("Not a general constraint attribute", error);
        }
        int[] ind = new int[1];
        String[] value = new String[1];
        error = GurobiJni.getstrattrlist(this.model, attr.toString(), this.num, 0, ind, value);
        if (error != 0) {
            throw new GRBException("Error at GRBGenConstr.get", error);
        }
        return value[0];
    }

    public void set(GRB.IntAttr attr, int newval) throws GRBException {
        if (this.num < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 5);
        if (error != 0) {
            throw new GRBException("Not a general constraint attribute", error);
        }
        int[] ind = new int[1];
        int[] tmp = new int[]{newval};
        error = GurobiJni.setintattrlist(this.model, attr.toString(), this.num, 0, ind, tmp);
        if (error != 0) {
            throw new GRBException("Error at GRBGenConstr.set", error);
        }
    }

    public void set(GRB.DoubleAttr attr, double newval) throws GRBException {
        if (this.num < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 5);
        if (error != 0) {
            throw new GRBException("Not a general constraint attribute", error);
        }
        int[] ind = new int[1];
        double[] tmp = new double[]{newval};
        error = GurobiJni.setdblattrlist(this.model, attr.toString(), this.num, 0, ind, tmp);
        if (error != 0) {
            throw new GRBException("Error at GRBGenConstr.set", error);
        }
    }

    public void set(GRB.StringAttr attr, String newval) throws GRBException {
        if (this.num < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 5);
        if (error != 0) {
            throw new GRBException("Not a general constraint attribute", error);
        }
        int[] ind = new int[1];
        String[] tmp = new String[]{newval};
        error = GurobiJni.setstrattrlist(this.model, attr.toString(), this.num, 0, ind, tmp);
        if (error != 0) {
            throw new GRBException("Error at GRBGenConstr.set", error);
        }
    }
}

