/*
 * Decompiled with CFR 0.152.
 */
package gurobi;

import gurobi.GRB;
import gurobi.GRBException;
import gurobi.GRBExpr;
import gurobi.GRBVar;
import java.util.ArrayList;

public class GRBLinExpr
extends GRBExpr {
    double constant;
    ArrayList<Double> coeffs;
    ArrayList<GRBVar> vars;

    protected void finalize() {
    }

    public GRBLinExpr() {
        this.constant = 0.0;
        this.coeffs = new ArrayList();
        this.vars = new ArrayList();
    }

    public GRBLinExpr(GRBLinExpr le) throws GRBException {
        this.constant = le.constant;
        this.coeffs = new ArrayList<Double>(le.coeffs);
        this.vars = new ArrayList<GRBVar>(le.vars);
    }

    public int size() {
        return this.vars.size();
    }

    public GRBVar getVar(int i) throws GRBException {
        if (i < 0 || i >= this.coeffs.size()) {
            throw new GRBException("Index i out of range", 10006);
        }
        return this.vars.get(i);
    }

    public double getCoeff(int i) throws GRBException {
        if (i < 0 || i >= this.coeffs.size()) {
            throw new GRBException("Index i out of range", 10006);
        }
        return this.coeffs.get(i);
    }

    public double getConstant() {
        return this.constant;
    }

    public double getValue() throws GRBException {
        double value = this.constant;
        for (int i = 0; i < this.coeffs.size(); ++i) {
            value += this.coeffs.get(i) * this.vars.get(i).get(GRB.DoubleAttr.X);
        }
        return value;
    }

    public void addConstant(double c) {
        this.constant += c;
    }

    public void addTerm(double coeff, GRBVar var) {
        this.coeffs.add(coeff);
        this.vars.add(var);
    }

    public void addTerms(double[] coeff, GRBVar[] var) throws GRBException {
        if (var == null) {
            return;
        }
        this.addTerms(coeff, var, 0, var.length);
    }

    public void addTerms(double[] coeff, GRBVar[] var, int start, int len) throws GRBException {
        int last = start + len;
        if (start < 0 || coeff != null && last > coeff.length || var == null || last > var.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        for (int i = start; i < last; ++i) {
            if (coeff == null) {
                this.coeffs.add(1.0);
            } else {
                this.coeffs.add(coeff[i]);
            }
            this.vars.add(var[i]);
        }
    }

    public void add(GRBLinExpr le) throws GRBException {
        this.multAdd(1.0, le);
    }

    public void multAdd(double m, GRBLinExpr le) throws GRBException {
        ArrayList<GRBVar> addvars;
        ArrayList<Double> addcoeffs;
        if (m == 0.0) {
            return;
        }
        if (this.coeffs == le.coeffs) {
            addcoeffs = new ArrayList<Double>(le.coeffs);
            addvars = new ArrayList<GRBVar>(le.vars);
        } else {
            addcoeffs = le.coeffs;
            addvars = le.vars;
        }
        if (m == 1.0) {
            this.coeffs.addAll(addcoeffs);
        } else {
            int size = le.size();
            for (int i = 0; i < size; ++i) {
                this.coeffs.add(m * addcoeffs.get(i));
            }
        }
        this.vars.addAll(addvars);
        this.constant += m * le.getConstant();
    }

    public void remove(int i) {
        if (i >= 0 && i < this.vars.size()) {
            this.coeffs.remove(i);
            this.vars.remove(i);
        }
    }

    public boolean remove(GRBVar v) {
        int size = this.vars.size();
        for (int i = size - 1; i >= 0; --i) {
            if (v != this.vars.get(i)) continue;
            this.coeffs.remove(i);
            this.vars.remove(i);
        }
        return size > this.vars.size();
    }

    public void clear() {
        this.constant = 0.0;
        this.coeffs.clear();
        this.vars.clear();
    }
}

