/*
 * Decompiled with CFR 0.152.
 */
import datastructures.DataSet;
import datastructures.DecisionTree;
import datastructures.NormalizedDataSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u001a\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0011\u001aN\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u0019\u001a&\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u000f\u001a\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010&\u001a\u00020\u0001\u001a\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010&\u001a\u00020\u0001\u001a\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010&\u001a\u00020\u0001\u001a>\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u0019\u001a\"\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000203012\u0006\u00104\u001a\u0002052\u0006\u0010 \u001a\u00020\u0011\u001a\"\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001e012\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u001c\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"dataDir", "", "dataSets", "", "getDataSets", "()[Ljava/lang/String;", "[Ljava/lang/String;", "instanceFileDir", "resultsDir", "scriptDir", "createTestReport", "", "reportName", "results", "", "LTestResult;", "measureMemoryMiB", "", "task", "Lkotlin/Function0;", "prettyTime", "millis", "printInfoCSV", "outputPath", "problemID", "", "algoId", "dataSet", "Ldatastructures/DataSet;", "subsetRatio", "", "subsetSeed", "timeoutSec", "testResult", "ubTimeMS", "printInfoConsole", "dataSetSize", "readNormalResults", "filePath", "readSATResults", "readTreeResults", "runTestFor", "algoType", "LAlgoType;", "dataSetName", "trainingData", "maxSize", "upperBound", "scheduleTimeout", "Lkotlin/Pair;", "Ljava/util/Timer;", "Ljava/util/TimerTask;", "algo", "LWitnessTreeAlgo;", "testClassification", "t", "Ldatastructures/DecisionTree;", "data", "Code"})
@SourceDebugExtension(value={"SMAP\nTestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestUtils.kt\nTestUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,790:1\n1#2:791\n1477#3:792\n1502#3,3:793\n1505#3,3:803\n1477#3:807\n1502#3,3:808\n1505#3,3:818\n1477#3:822\n1502#3,3:823\n1505#3,3:833\n1726#3,3:837\n766#3:840\n857#3,2:841\n1747#3,3:843\n1774#3,4:846\n1774#3,4:850\n372#4,7:796\n372#4,7:811\n372#4,7:826\n215#5:806\n215#5:821\n215#5:836\n216#5:854\n216#5:855\n216#5:856\n*S KotlinDebug\n*F\n+ 1 TestUtils.kt\nTestUtilsKt\n*L\n706#1:792\n706#1:793,3\n706#1:803,3\n709#1:807\n709#1:808,3\n709#1:818,3\n711#1:822\n711#1:823,3\n711#1:833,3\n713#1:837,3\n716#1:840\n716#1:841,2\n717#1:843,3\n723#1:846,4\n724#1:850,4\n706#1:796,7\n709#1:811,7\n711#1:826,7\n706#1:806\n709#1:821\n711#1:836\n711#1:854\n709#1:855\n706#1:856\n*E\n"})
public final class TestUtilsKt {
    @NotNull
    public static final String resultsDir = "../Experimente/Ergebnisse";
    @NotNull
    public static final String instanceFileDir = "../Experimente/Instanzen";
    @NotNull
    public static final String scriptDir = "../Experimente";
    @NotNull
    public static final String dataDir = "../Daten";
    @NotNull
    private static final String[] dataSets;

    @NotNull
    public static final String[] getDataSets() {
        return dataSets;
    }

    public static final void printInfoCSV(@NotNull String outputPath, int problemID, int algoId, @NotNull DataSet dataSet, float subsetRatio, int subsetSeed, long timeoutSec, @NotNull TestResult testResult, int ubTimeMS) {
        Intrinsics.checkNotNullParameter(outputPath, "outputPath");
        Intrinsics.checkNotNullParameter(dataSet, "dataSet");
        Intrinsics.checkNotNullParameter(testResult, "testResult");
        NormalizedDataSet normData = dataSet.normalize();
        StringBuilder builder = new StringBuilder();
        builder.append(problemID + ";");
        builder.append(algoId + ";");
        builder.append(testResult.getDataSetName() + ";");
        builder.append(dataSet.getN() + ";");
        builder.append(subsetRatio + ";");
        builder.append(subsetSeed + ";");
        builder.append(testResult.getD() + ";");
        builder.append(testResult.getS() + ";");
        builder.append(timeoutSec + ";");
        builder.append(testResult.getTimeMS() + (long)ubTimeMS + ";");
        builder.append(testResult.getMemoryMiB() + ";");
        builder.append(testResult.getTimeoutHappened() + ";");
        builder.append(testResult.getFoundTree() + ";");
        builder.append(testResult.getTreeSize() + ";");
        String string = "%.2f";
        Object[] objectArray = new Object[]{Float.valueOf(testResult.getCorrectTrainingData())};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
        builder.append(string2 + ";");
        builder.append(testResult.getSearchTreeNodes() + ";");
        builder.append(testResult.getLowerBoundEffect() + ";");
        builder.append(testResult.getSubsetConstraintEffect() + ";");
        builder.append(testResult.getUniqueSets() + ";");
        builder.append(testResult.getCopiedSets() + ";");
        builder.append(testResult.getSetTrieSize() + ";");
        builder.append(testResult.getUpperBound() + ";");
        builder.append(testResult.getDepthSum() + ";");
        builder.append(testResult.getMinDepth() + ";");
        builder.append(testResult.getMaxDepth() + ";");
        builder.append(normData.getDelta() + ";");
        builder.append(normData.getNumberOfCuts() + ";");
        builder.append(normData.getBigD() + ";");
        builder.append(testResult.getPairLBCalculated() + ";");
        builder.append(testResult.getPairLBEffect() + ";");
        builder.append(testResult.getCachingSearchTreeNodes() + ";");
        builder.append(testResult.getPairLBGoodTime() + ";");
        builder.append(testResult.getPairLBBadTime() + ";");
        builder.append(testResult.getGreedyEffect() + ";");
        builder.append(testResult.getGreedyTime() + ";");
        builder.append(testResult.getDtFString() + ";");
        PrintStream out = new PrintStream(new FileOutputStream(new File(outputPath), true));
        out.println(builder.toString());
        out.close();
    }

    @NotNull
    public static final List<TestResult> readNormalResults(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        LinkedList<TestResult> results = new LinkedList<TestResult>();
        FilesKt.forEachLine$default(new File(filePath), null, new Function1<String, Unit>(results){
            final /* synthetic */ LinkedList<TestResult> $results;
            {
                this.$results = $results;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull String l) {
                String string;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter(l, "l");
                String[] stringArray = new String[]{";"};
                Iterable $this$filter$iv = StringsKt.split$default((CharSequence)l, stringArray, false, 0, 6, null);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank(it);
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List splits = (List)destination$iv$iv;
                String string2 = (String)CollectionsKt.getOrNull(splits, 0);
                if (string2 == null) {
                    string2 = "0";
                }
                int n = Integer.parseInt(string2);
                String string3 = (String)CollectionsKt.getOrNull(splits, 2);
                if (string3 == null) {
                    string3 = "0";
                }
                if ((string = (String)CollectionsKt.getOrNull(splits, 1)) == null) {
                    string = "0";
                }
                AlgoType algoType = AlgoType.Companion.getAlgoTypeFromId(Integer.parseInt(string));
                String string4 = (String)CollectionsKt.getOrNull(splits, 4);
                if (string4 == null) {
                    string4 = "0.0";
                }
                float f = Float.parseFloat(string4);
                String string5 = (String)CollectionsKt.getOrNull(splits, 6);
                if (string5 == null) {
                    string5 = "0";
                }
                int n2 = Integer.parseInt(string5);
                String string6 = (String)CollectionsKt.getOrNull(splits, 7);
                if (string6 == null) {
                    string6 = "0";
                }
                int n3 = Integer.parseInt(string6);
                String string7 = (String)CollectionsKt.getOrNull(splits, 12);
                if (string7 == null) {
                    string7 = "false";
                }
                boolean bl = Boolean.parseBoolean(string7);
                String string8 = (String)CollectionsKt.getOrNull(splits, 13);
                if (string8 == null) {
                    string8 = "0";
                }
                int n4 = Integer.parseInt(string8);
                String string9 = (String)CollectionsKt.getOrNull(splits, 9);
                if (string9 == null) {
                    string9 = "0";
                }
                long l2 = Long.parseLong(string9);
                String string10 = (String)CollectionsKt.getOrNull(splits, 10);
                if (string10 == null) {
                    string10 = "0";
                }
                long l3 = Long.parseLong(string10);
                String string11 = (String)CollectionsKt.getOrNull(splits, 11);
                if (string11 == null) {
                    string11 = "false";
                }
                boolean bl3 = Boolean.parseBoolean(string11);
                String string12 = (String)CollectionsKt.getOrNull(splits, 14);
                if (string12 == null) {
                    string12 = "0.0";
                }
                float f2 = Float.parseFloat(string12);
                String string13 = (String)CollectionsKt.getOrNull(splits, 15);
                if (string13 == null) {
                    string13 = "0";
                }
                int n5 = Integer.parseInt(string13);
                String string14 = (String)CollectionsKt.getOrNull(splits, 16);
                if (string14 == null) {
                    string14 = "0";
                }
                int n6 = Integer.parseInt(string14);
                String string15 = (String)CollectionsKt.getOrNull(splits, 17);
                if (string15 == null) {
                    string15 = "0";
                }
                int n7 = Integer.parseInt(string15);
                String string16 = (String)CollectionsKt.getOrNull(splits, 18);
                if (string16 == null) {
                    string16 = "0";
                }
                int n8 = Integer.parseInt(string16);
                String string17 = (String)CollectionsKt.getOrNull(splits, 19);
                if (string17 == null) {
                    string17 = "0";
                }
                int n9 = Integer.parseInt(string17);
                String string18 = (String)CollectionsKt.getOrNull(splits, 20);
                if (string18 == null) {
                    string18 = "0";
                }
                int n10 = Integer.parseInt(string18);
                String string19 = (String)CollectionsKt.getOrNull(splits, 21);
                if (string19 == null) {
                    string19 = "0";
                }
                int n11 = Integer.parseInt(string19);
                String string20 = (String)CollectionsKt.getOrNull(splits, 22);
                if (string20 == null) {
                    string20 = "0";
                }
                int n12 = Integer.parseInt(string20);
                String string21 = (String)CollectionsKt.getOrNull(splits, 23);
                if (string21 == null) {
                    string21 = "0";
                }
                int n13 = Integer.parseInt(string21);
                String string22 = (String)CollectionsKt.getOrNull(splits, 24);
                if (string22 == null) {
                    string22 = "0";
                }
                int n14 = Integer.parseInt(string22);
                String string23 = (String)CollectionsKt.getOrNull(splits, 28);
                if (string23 == null) {
                    string23 = "0";
                }
                int n15 = Integer.parseInt(string23);
                String string24 = (String)CollectionsKt.getOrNull(splits, 29);
                if (string24 == null) {
                    string24 = "0";
                }
                int n16 = Integer.parseInt(string24);
                String string25 = (String)CollectionsKt.getOrNull(splits, 30);
                if (string25 == null) {
                    string25 = "0";
                }
                int n17 = Integer.parseInt(string25);
                String string26 = (String)CollectionsKt.getOrNull(splits, 31);
                if (string26 == null) {
                    string26 = "0";
                }
                long l4 = Long.parseLong(string26);
                String string27 = (String)CollectionsKt.getOrNull(splits, 32);
                if (string27 == null) {
                    string27 = "0";
                }
                long l5 = Long.parseLong(string27);
                String string28 = (String)CollectionsKt.getOrNull(splits, 33);
                if (string28 == null) {
                    string28 = "0";
                }
                int n18 = Integer.parseInt(string28);
                String string29 = (String)CollectionsKt.getOrNull(splits, 34);
                if (string29 == null) {
                    string29 = "0";
                }
                long l6 = Long.parseLong(string29);
                String string30 = (String)CollectionsKt.getOrNull(splits, 35);
                if (string30 == null) {
                    string30 = "-1:-1:false:-1:-1";
                }
                this.$results.add(new TestResult(n, string3, algoType, f, n2, n3, bl, n4, l2, l3, bl3, f2, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, l4, l5, n18, l6, string30));
            }
        }, 1, null);
        return results;
    }

    @NotNull
    public static final List<TestResult> readSATResults(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        LinkedList<TestResult> results = new LinkedList<TestResult>();
        FilesKt.forEachLine$default(new File(filePath), null, new Function1<String, Unit>(results){
            final /* synthetic */ LinkedList<TestResult> $results;
            {
                this.$results = $results;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull String l) {
                String string;
                String string2;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter(l, "l");
                String[] stringArray = new String[]{";"};
                Iterable $this$filter$iv = StringsKt.split$default((CharSequence)l, stringArray, false, 0, 6, null);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank(it);
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List splits = (List)destination$iv$iv;
                String string3 = (String)CollectionsKt.getOrNull(splits, 0);
                if (string3 == null) {
                    string3 = "0";
                }
                int n = Integer.parseInt(string3);
                String string4 = (String)CollectionsKt.getOrNull(splits, 1);
                if (string4 == null) {
                    string4 = string2 = "";
                }
                if ((string = (String)CollectionsKt.getOrNull(splits, 2)) == null) {
                    string = "0.0";
                }
                float f = Float.parseFloat(string);
                String string5 = (String)CollectionsKt.getOrNull(splits, 5);
                if (string5 == null) {
                    string5 = "0";
                }
                long l2 = Long.parseLong(string5);
                String string6 = (String)CollectionsKt.getOrNull(splits, 6);
                if (string6 == null) {
                    string6 = "false";
                }
                boolean bl = Boolean.parseBoolean(string6);
                String string7 = (String)CollectionsKt.getOrNull(splits, 6);
                if (string7 == null) {
                    string7 = "false";
                }
                boolean bl3 = !Boolean.parseBoolean(string7);
                this.$results.add(new TestResult(n, string2, null, f, 0, 0, bl3, 0, l2, 0L, bl, 0.0f, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0L, 0L, 0, 0L, null, 1073740468, null));
            }
        }, 1, null);
        return results;
    }

    @NotNull
    public static final List<TestResult> readTreeResults(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        LinkedList<TestResult> results = new LinkedList<TestResult>();
        FilesKt.forEachLine$default(new File(filePath), null, new Function1<String, Unit>(results){
            final /* synthetic */ LinkedList<TestResult> $results;
            {
                this.$results = $results;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull String l) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter(l, "l");
                Object object = new String[]{","};
                Iterable $this$filter$iv = StringsKt.split$default((CharSequence)l, object, false, 0, 6, null);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank(it);
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List splits = (List)destination$iv$iv;
                object = (String)splits.get(0);
                String string = (String)splits.get(1);
                this.$results.add(new TestResult(0, (String)object, null, 0.0f, 0, 0, true, 0, 0L, 0L, false, 0.0f, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0L, 0L, 0, 0L, string, 536869821, null));
            }
        }, 1, null);
        return results;
    }

    @NotNull
    public static final TestResult runTestFor(@NotNull AlgoType algoType, @NotNull String dataSetName, @NotNull DataSet trainingData, float subsetRatio, int maxSize, long timeoutSec, int upperBound) {
        float f;
        Intrinsics.checkNotNullParameter((Object)algoType, "algoType");
        Intrinsics.checkNotNullParameter(dataSetName, "dataSetName");
        Intrinsics.checkNotNullParameter(trainingData, "trainingData");
        WitnessTreeAlgo algo = new WitnessTreeAlgo(trainingData, algoType);
        Ref.ObjectRef<DecisionTree> tree = new Ref.ObjectRef<DecisionTree>();
        Ref.LongRef timeMS = new Ref.LongRef();
        Pair<Timer, TimerTask> pair = TestUtilsKt.scheduleTimeout(algo, timeoutSec);
        Timer timer = pair.component1();
        TimerTask timeoutTask = pair.component2();
        long memoryMiB2 = TestUtilsKt.measureMemoryMiB(new Function0<Unit>(timeMS, tree, algo, maxSize, upperBound){
            final /* synthetic */ Ref.LongRef $timeMS;
            final /* synthetic */ Ref.ObjectRef<DecisionTree> $tree;
            final /* synthetic */ WitnessTreeAlgo $algo;
            final /* synthetic */ int $maxSize;
            final /* synthetic */ int $upperBound;
            {
                this.$timeMS = $timeMS;
                this.$tree = $tree;
                this.$algo = $algo;
                this.$maxSize = $maxSize;
                this.$upperBound = $upperBound;
                super(0);
            }

            public final void invoke() {
                Ref.ObjectRef<DecisionTree> objectRef = this.$tree;
                WitnessTreeAlgo witnessTreeAlgo = this.$algo;
                int n = this.$maxSize;
                int n2 = this.$upperBound;
                boolean $i$f$measureTimeMillis = false;
                long start$iv = System.currentTimeMillis();
                Ref.LongRef longRef = this.$timeMS;
                boolean bl = false;
                objectRef.element = witnessTreeAlgo.findTree(n, n2);
                longRef.element = System.currentTimeMillis() - start$iv;
            }
        });
        boolean timeoutHappened = !timeoutTask.cancel();
        timer.cancel();
        DecisionTree decisionTree = (DecisionTree)tree.element;
        if (decisionTree != null) {
            DecisionTree it = decisionTree;
            boolean bl = false;
            f = ((Number)TestUtilsKt.testClassification(it, trainingData).getSecond()).floatValue();
        } else {
            f = 0.0f;
        }
        float correctTrainingData = f;
        int n = trainingData.getD();
        int n2 = algoType.getStrategy() > 0 ? -1 : maxSize;
        boolean bl = tree.element != null;
        DecisionTree decisionTree2 = (DecisionTree)tree.element;
        int n3 = decisionTree2 != null ? decisionTree2.getInnerCount() : -1;
        long l = timeMS.element;
        int n4 = algo.getSearchTreeNodes();
        int n5 = algo.getLowerBoundEffect();
        int n6 = algo.getSubsetConstraintEffect();
        int n7 = algo.getUniqueSets();
        int n8 = algo.getCopiedSets();
        int n9 = algo.getSetTrieSize();
        DecisionTree decisionTree3 = (DecisionTree)tree.element;
        int n10 = decisionTree3 != null ? DecisionTree.getDepthSum$default(decisionTree3, 0, 0, 3, null) : -1;
        DecisionTree decisionTree4 = (DecisionTree)tree.element;
        int n11 = decisionTree4 != null ? DecisionTree.getMinDepth$default(decisionTree4, 0, 0, 3, null) : -1;
        DecisionTree decisionTree5 = (DecisionTree)tree.element;
        int n12 = decisionTree5 != null ? DecisionTree.getMaxDepth$default(decisionTree5, 0, 0, 3, null) : -1;
        int n13 = algo.getPairLBCalculated();
        int n14 = algo.getPairLBEffect();
        int n15 = algo.getCachingSearchTreeNodes();
        long l2 = algo.getPairLBGoodTime();
        long l3 = algo.getPairLBBadTime();
        int n16 = algo.getGreedyEffect();
        long l4 = algo.getGreedyTime();
        Object object = (DecisionTree)tree.element;
        if (object == null || (object = ((DecisionTree)object).toFormattedString()) == null) {
            object = "-1:-1:false:-1:-1";
        }
        return new TestResult(-1, dataSetName, algoType, subsetRatio, n, n2, bl, n3, l, memoryMiB2, timeoutHappened, correctTrainingData, n4, n5, n6, n7, n8, n9, upperBound, n10, n11, n12, n13, n14, n15, l2, l3, n16, l4, (String)object);
    }

    @NotNull
    public static final Pair<Integer, Float> testClassification(@NotNull DecisionTree t, @NotNull DataSet data) {
        Intrinsics.checkNotNullParameter(t, "t");
        Intrinsics.checkNotNullParameter(data, "data");
        int countCorrectData = 0;
        int n = data.getN();
        for (int e = 0; e < n; ++e) {
            boolean c = t.classifyExample(data.getValues()[e]);
            if (c != data.getCla()[e]) continue;
            ++countCorrectData;
        }
        return new Pair<Integer, Float>(countCorrectData, Float.valueOf((float)countCorrectData / (float)data.getN()));
    }

    public static final void printInfoConsole(int dataSetSize, int subsetSeed, long timeoutSec, @NotNull TestResult testResult) {
        Intrinsics.checkNotNullParameter(testResult, "testResult");
        System.out.println((Object)("Dataset:           " + testResult.getDataSetName()));
        System.out.println((Object)("Total Examples:    " + dataSetSize));
        System.out.println((Object)("Training Examples: " + testResult.getSubsetRatio()));
        System.out.println((Object)("Dimensions:        " + testResult.getD()));
        System.out.println((Object)("Max Tree Size:     " + testResult.getS()));
        System.out.println();
        if (testResult.getTimeoutHappened()) {
            System.out.println((Object)("Timeout after " + timeoutSec + " seconds."));
        } else {
            if (testResult.getFoundTree()) {
                System.out.println((Object)"Tree found!");
                System.out.println((Object)("Size:                  " + testResult.getTreeSize()));
                System.out.println((Object)("Correct Training Data: " + testResult.getCorrectTrainingData()));
            } else {
                System.out.println((Object)"Tree not found!");
            }
            System.out.println((Object)("Time:   " + TestUtilsKt.prettyTime(testResult.getTimeMS())));
            System.out.println((Object)("Memory: " + testResult.getMemoryMiB() + "MiB"));
            System.out.println((Object)("Search Tree:   " + testResult.getSearchTreeNodes()));
            System.out.println((Object)("LB Effect:     " + testResult.getLowerBoundEffect()));
            System.out.println((Object)("Unique Sets:   " + testResult.getUniqueSets()));
            System.out.println((Object)("Copied Sets:   " + testResult.getCopiedSets()));
            System.out.println((Object)("SetTrie Size:  " + testResult.getSetTrieSize()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void createTestReport(@NotNull String reportName, @NotNull List<TestResult> results) {
        Object $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(reportName, "reportName");
        Intrinsics.checkNotNullParameter(results, "results");
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String curTime = sdf.format(cal.getTime());
        boolean foundName = false;
        int num = 0;
        File outputFile = new File("reports/debug.txt");
        while (!foundName) {
            outputFile = new File("reports/Report_" + curTime + "_" + reportName + "_" + num + ".txt");
            if (outputFile.exists()) {
                ++num;
                continue;
            }
            outputFile.createNewFile();
            foundName = true;
        }
        PrintStream out = new PrintStream(outputFile);
        Iterator iterator2 = ((Iterable)results).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        TestResult it422 = (TestResult)iterator2.next();
        boolean bl = false;
        int it422 = String.valueOf(it422.getMemoryMiB()).length();
        while (iterator2.hasNext()) {
            TestResult it32 = (TestResult)iterator2.next();
            $i$a$-maxOf-TestUtilsKt$createTestReport$maxMemoryLength$1 = false;
            int it32 = String.valueOf(it32.getMemoryMiB()).length();
            if (it422 >= it32) continue;
            it422 = it32;
        }
        int maxMemoryLength = it422;
        Iterator it422 = ((Iterable)results).iterator();
        if (!it422.hasNext()) {
            throw new NoSuchElementException();
        }
        TestResult it622 = (TestResult)it422.next();
        boolean bl2 = false;
        int it622 = String.valueOf(it622.getSearchTreeNodes()).length();
        while (it422.hasNext()) {
            TestResult it52 = (TestResult)it422.next();
            $i$a$-maxOf-TestUtilsKt$createTestReport$maxSearchTreeNodesLength$1 = false;
            int it52 = String.valueOf(it52.getSearchTreeNodes()).length();
            if (it622 >= it52) continue;
            it622 = it52;
        }
        int maxSearchTreeNodesLength = it622;
        Iterable $this$groupBy$iv = results;
        boolean $i$f$groupBy = false;
        Iterable it622 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            TestResult it = (TestResult)element$iv$iv;
            boolean bl3 = false;
            String key$iv$iv = it.getDataSetName();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = MapsKt.toSortedMap(destination$iv$iv);
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Object $this$getOrPut$iv$iv$iv2;
            void $this$groupByTo$iv$iv2;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator3.next();
            boolean bl5 = false;
            String dataSetName = (String)entry.getKey();
            List l = (List)entry.getValue();
            Intrinsics.checkNotNull(l);
            out.println("Results for " + dataSetName + " (d = " + ((TestResult)CollectionsKt.first(l)).getD() + "):");
            Iterable $this$groupBy$iv2 = l;
            boolean $i$f$groupBy2 = false;
            $this$getOrPut$iv$iv$iv = $this$groupBy$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                Object object;
                TestResult it = (TestResult)element$iv$iv;
                boolean bl6 = false;
                Float key$iv$iv = Float.valueOf(it.getSubsetRatio());
                $this$getOrPut$iv$iv$iv2 = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv2.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl7 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$forEach$iv2 = MapsKt.toSortedMap(destination$iv$iv2);
            boolean $i$f$forEach2 = false;
            Iterator iterator4 = $this$forEach$iv2.entrySet().iterator();
            while (iterator4.hasNext()) {
                void $this$groupByTo$iv$iv3;
                Map.Entry element$iv2;
                Map.Entry entry2 = element$iv2 = iterator4.next();
                boolean bl8 = false;
                Float n = (Float)entry2.getKey();
                List l2 = (List)entry2.getValue();
                Intrinsics.checkNotNull(l2);
                Iterable $this$groupBy$iv3 = l2;
                boolean $i$f$groupBy3 = false;
                $this$getOrPut$iv$iv$iv2 = $this$groupBy$iv3;
                Map destination$iv$iv3 = new LinkedHashMap();
                boolean $i$f$groupByTo3 = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv3) {
                    Object object;
                    TestResult it = (TestResult)element$iv$iv;
                    boolean bl9 = false;
                    Integer key$iv$iv = it.getS();
                    Map $this$getOrPut$iv$iv$iv3 = destination$iv$iv3;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv3.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl10 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv3.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Map $this$forEach$iv3 = MapsKt.toSortedMap(destination$iv$iv3);
                boolean $i$f$forEach3 = false;
                Iterator iterator5 = $this$forEach$iv3.entrySet().iterator();
                while (iterator5.hasNext()) {
                    int n2;
                    int n3;
                    int count$iv;
                    int n4;
                    Iterable $this$count$iv;
                    TestResult it;
                    TestResult testResult;
                    Object object;
                    long l3;
                    long l4;
                    boolean bl11;
                    List resLFiltered;
                    TestResult it2;
                    List resL;
                    block39: {
                        void $this$filterTo$iv$iv;
                        Object element$iv32;
                        boolean bl12;
                        block38: {
                            Map.Entry element$iv4;
                            Map.Entry entry3 = element$iv4 = iterator5.next();
                            boolean bl13 = false;
                            Integer s = (Integer)entry3.getKey();
                            resL = (List)entry3.getValue();
                            String bl9 = "# Instances = %2d, n = %4d, s = %2d: ";
                            Object[] key$iv$iv = new Object[]{resL.size(), n, s};
                            String string = String.format(bl9, Arrays.copyOf(key$iv$iv, key$iv$iv.length));
                            Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
                            out.print(string);
                            Intrinsics.checkNotNull(resL);
                            Iterable $this$all$iv = resL;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl12 = true;
                            } else {
                                for (Object element$iv32 : $this$all$iv) {
                                    TestResult it3 = (TestResult)element$iv32;
                                    boolean bl14 = false;
                                    if (it3.getTimeoutHappened()) continue;
                                    bl12 = false;
                                    break block38;
                                }
                                bl12 = true;
                            }
                        }
                        if (bl12) {
                            out.println("Timeout for all Instances");
                            continue;
                        }
                        Iterable $this$filter$iv = resL;
                        boolean $i$f$filter = false;
                        element$iv32 = $this$filter$iv;
                        Collection destination$iv$iv4 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            it2 = (TestResult)element$iv$iv;
                            boolean bl15 = false;
                            if (!(!it2.getTimeoutHappened())) continue;
                            destination$iv$iv4.add(element$iv$iv);
                        }
                        resLFiltered = (List)destination$iv$iv4;
                        Iterable $this$any$iv = resLFiltered;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl11 = false;
                        } else {
                            for (Object element$iv5 : $this$any$iv) {
                                TestResult it5 = (TestResult)element$iv5;
                                boolean bl16 = false;
                                if (!(it5.getFoundTree() && !(it5.getCorrectTrainingData() == 1.0f))) continue;
                                bl11 = true;
                                break block39;
                            }
                            bl11 = false;
                        }
                    }
                    if (bl11) {
                        throw new Exception("Not 1");
                    }
                    Iterable iterable = resLFiltered;
                    long l5 = 0L;
                    Iterator iterator6 = iterable.iterator();
                    while (iterator6.hasNext()) {
                        Object element$iv$iv;
                        element$iv$iv = iterator6.next();
                        it2 = (TestResult)element$iv$iv;
                        l4 = l5;
                        boolean bl17 = false;
                        l3 = it2.getTimeMS();
                        l5 = l4 + l3;
                    }
                    long timeMSAvg = l5 / (long)resLFiltered.size();
                    iterator6 = ((Iterable)resLFiltered).iterator();
                    if (!iterator6.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object it82 = (TestResult)iterator6.next();
                    boolean bl18 = false;
                    long it82 = ((TestResult)it82).getTimeMS();
                    while (iterator6.hasNext()) {
                        TestResult it72 = (TestResult)iterator6.next();
                        $i$a$-maxOf-TestUtilsKt$createTestReport$2$2$2$timeMSWorst$1 = false;
                        long it72 = it72.getTimeMS();
                        if (it82 >= it72) continue;
                        it82 = it72;
                    }
                    long timeMSWorst = it82;
                    it82 = resLFiltered;
                    long l6 = 0L;
                    Iterator iterator7 = it82.iterator();
                    while (iterator7.hasNext()) {
                        object = iterator7.next();
                        testResult = (TestResult)object;
                        l4 = l6;
                        boolean bl19 = false;
                        l3 = it.getMemoryMiB();
                        l6 = l4 + l3;
                    }
                    long memoryMiBAvg = l6 / (long)resLFiltered.size();
                    out.print(TestUtilsKt.prettyTime(timeMSAvg) + " " + TestUtilsKt.prettyTime(timeMSWorst) + " ");
                    it82 = "%" + maxMemoryLength + "dMiB ";
                    Object[] it72 = new Object[]{memoryMiBAvg};
                    String string = String.format((String)it82, Arrays.copyOf(it72, it72.length));
                    Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
                    out.print(string);
                    it82 = resL;
                    PrintStream printStream = out;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n4 = 0;
                    } else {
                        count$iv = 0;
                        for (Object element$iv6 : $this$count$iv) {
                            it = (TestResult)element$iv6;
                            boolean bl20 = false;
                            if (!it.getTimeoutHappened() || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n4 = count$iv;
                    }
                    int n5 = n4;
                    printStream.print("Timeout: " + n5 + "/" + resL.size() + " ");
                    $this$count$iv = resLFiltered;
                    printStream = out;
                    $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n3 = 0;
                    } else {
                        count$iv = 0;
                        for (Object element$iv6 : $this$count$iv) {
                            it = (TestResult)element$iv6;
                            boolean bl21 = false;
                            if (!it.getFoundTree() || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n3 = count$iv;
                    }
                    n5 = n3;
                    printStream.print("Tree found: " + n5 + "/" + resLFiltered.size() + " ");
                    String string2 = "Search tree nodes: %" + maxSearchTreeNodesLength + "d ";
                    Object[] objectArray = new Object[1];
                    Iterable iterable2 = resLFiltered;
                    int n6 = 0;
                    Object[] objectArray2 = objectArray;
                    printStream = out;
                    int n7 = 0;
                    object = iterable2.iterator();
                    while (object.hasNext()) {
                        void it7;
                        TestResult bl21 = testResult = object.next();
                        n2 = n7;
                        boolean bl22 = false;
                        int n8 = it7.getSearchTreeNodes();
                        n7 = n2 + n8;
                    }
                    n2 = n7;
                    objectArray2[n6] = n2 / resLFiltered.size();
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string3, "format(this, *args)");
                    printStream.print(string3);
                    out.println("LB: " + ((TestResult)resLFiltered.get(0)).getLowerBoundEffect() + " ");
                }
            }
        }
        out.close();
    }

    @NotNull
    public static final Pair<Timer, TimerTask> scheduleTimeout(@NotNull WitnessTreeAlgo algo, long timeoutSec) {
        Timer timer;
        Intrinsics.checkNotNullParameter(algo, "algo");
        algo.setTimeoutHappened(false);
        Timer timer2 = timer = new Timer();
        long l = timeoutSec * (long)1000;
        TimerTask timerTask2 = new TimerTask(algo){
            final /* synthetic */ WitnessTreeAlgo $algo$inlined;
            {
                this.$algo$inlined = witnessTreeAlgo;
            }

            public void run() {
                TimerTask $this$scheduleTimeout_u24lambda_u2418 = this;
                boolean bl = false;
                this.$algo$inlined.setTimeoutHappened(true);
            }
        };
        timer2.schedule(timerTask2, l);
        return new Pair<Timer, TimerTask>(timer, timerTask2);
    }

    @NotNull
    public static final String prettyTime(long millis) {
        long h = 0L;
        long m = 0L;
        long s = 0L;
        long ms = millis;
        if (ms >= 3600000L) {
            h = ms / 3600000L;
            ms %= 3600000L;
        }
        if (ms >= 60000L) {
            m = ms / 60000L;
            ms %= 60000L;
        }
        if (ms >= 1000L) {
            s = ms / 1000L;
            ms %= 1000L;
        }
        String string = "%d:%02d:%02d.%03d";
        Object[] objectArray = new Object[]{h, m, s, ms};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
        return string2;
    }

    public static final long measureMemoryMiB(@NotNull Function0<Unit> task) {
        Intrinsics.checkNotNullParameter(task, "task");
        Runtime runtime = Runtime.getRuntime();
        Ref.LongRef memory = new Ref.LongRef();
        memory.element = (runtime.totalMemory() - runtime.freeMemory()) / (long)0x100000;
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(memory, runtime){
            final /* synthetic */ Ref.LongRef $memory$inlined;
            final /* synthetic */ Runtime $runtime$inlined;
            {
                this.$memory$inlined = longRef;
                this.$runtime$inlined = runtime;
            }

            public void run() {
                TimerTask $this$measureMemoryMiB_u24lambda_u2419 = this;
                boolean bl = false;
                this.$memory$inlined.element = Math.max(this.$memory$inlined.element, (this.$runtime$inlined.totalMemory() - this.$runtime$inlined.freeMemory()) / (long)0x100000);
            }
        }, 0L, 100L);
        task.invoke();
        timer.cancel();
        return Math.max(memory.element, (runtime.totalMemory() - runtime.freeMemory()) / (long)0x100000);
    }

    static {
        String[] stringArray = new String[]{"appendicitis", "australian", "auto", "backache", "biomed", "breast-cancer", "bupa", "cars", "cleve", "cleveland", "cleveland-nominal", "cloud", "colic", "contraceptive", "dermatology", "diabetes", "ecoli", "glass", "glass2", "haberman", "hayes-roth", "heart-c", "heart-h", "heart-statlog", "hepatitis", "hungarian", "lupus", "lymphography", "molecular_biology_promoters", "new-thyroid", "postoperative-patient-data", "schizo", "soybean", "spect", "tae"};
        dataSets = stringArray;
    }
}

