/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0011\n\u0002\u0010\u0013\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 02\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001cJ\u001a\u0010$\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020\u00032\b\b\u0002\u0010&\u001a\u00020\u0003J\u0018\u0010'\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u001c2\b\b\u0002\u0010%\u001a\u00020\u0003J\u001a\u0010(\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020\u00032\b\b\u0002\u0010&\u001a\u00020\u0003J\u001a\u0010)\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020\u00032\b\b\u0002\u0010&\u001a\u00020\u0003J\u000e\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u0003J\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020/R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u0011\u0010\u0014\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0011\u0010\u0016\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0004R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000f\u00a8\u00061"}, d2={"Ldatastructures/DecisionTree;", "", "size", "", "(I)V", "cla", "", "getCla", "()[Z", "dim", "", "getDim", "()[I", "innerCount", "getInnerCount", "()I", "leafCount", "getLeafCount", "leftChild", "getLeftChild", "parent", "getParent", "rightChild", "getRightChild", "root", "getRoot", "setRoot", "thr", "", "getThr", "()[D", "vertexCount", "getVertexCount", "classifyExample", "", "e", "getDepthSum", "subRoot", "curDepth", "getLeafOfExample", "getMaxDepth", "getMinDepth", "isLeaf", "vertex", "toFormattedString", "", "verifyDataStructure", "", "Companion", "Code"})
public final class DecisionTree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int innerCount;
    private final int leafCount;
    private final int vertexCount;
    private int root;
    @NotNull
    private final int[] parent;
    @NotNull
    private final int[] leftChild;
    @NotNull
    private final int[] rightChild;
    @NotNull
    private final int[] dim;
    @NotNull
    private final double[] thr;
    @NotNull
    private final boolean[] cla;

    public DecisionTree(int size) {
        int n;
        this.innerCount = size;
        this.leafCount = size + 1;
        this.vertexCount = this.innerCount + this.leafCount;
        this.root = -1;
        int n2 = 0;
        int n3 = this.vertexCount;
        Object[] objectArray = new int[n3];
        DecisionTree decisionTree = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = -1;
        }
        decisionTree.parent = objectArray;
        n2 = 0;
        n3 = this.vertexCount;
        objectArray = new int[n3];
        decisionTree = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = -1;
        }
        decisionTree.leftChild = objectArray;
        n2 = 0;
        n3 = this.vertexCount;
        objectArray = new int[n3];
        decisionTree = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = -1;
        }
        decisionTree.rightChild = objectArray;
        n2 = 0;
        n3 = this.vertexCount;
        objectArray = new int[n3];
        decisionTree = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = -1;
        }
        decisionTree.dim = objectArray;
        n2 = 0;
        n3 = this.vertexCount;
        objectArray = new double[n3];
        decisionTree = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = (int)-1.0;
        }
        decisionTree.thr = objectArray;
        n2 = 0;
        n3 = this.vertexCount;
        objectArray = new boolean[n3];
        decisionTree = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = 0;
        }
        decisionTree.cla = (boolean[])objectArray;
    }

    public final int getInnerCount() {
        return this.innerCount;
    }

    public final int getLeafCount() {
        return this.leafCount;
    }

    public final int getVertexCount() {
        return this.vertexCount;
    }

    public final int getRoot() {
        return this.root;
    }

    public final void setRoot(int n) {
        this.root = n;
    }

    @NotNull
    public final int[] getParent() {
        return this.parent;
    }

    @NotNull
    public final int[] getLeftChild() {
        return this.leftChild;
    }

    @NotNull
    public final int[] getRightChild() {
        return this.rightChild;
    }

    @NotNull
    public final int[] getDim() {
        return this.dim;
    }

    @NotNull
    public final double[] getThr() {
        return this.thr;
    }

    @NotNull
    public final boolean[] getCla() {
        return this.cla;
    }

    public final boolean isLeaf(int vertex) {
        return vertex >= this.innerCount;
    }

    public final boolean classifyExample(@NotNull double[] e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return this.cla[DecisionTree.getLeafOfExample$default(this, e, 0, 2, null)];
    }

    public final int getLeafOfExample(@NotNull double[] e, int subRoot) {
        Intrinsics.checkNotNullParameter(e, "e");
        int curRoot = subRoot;
        while (!this.isLeaf(curRoot)) {
            curRoot = e[this.dim[curRoot]] <= this.thr[curRoot] ? this.leftChild[curRoot] : this.rightChild[curRoot];
        }
        return curRoot;
    }

    public static /* synthetic */ int getLeafOfExample$default(DecisionTree decisionTree, double[] dArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = decisionTree.root;
        }
        return decisionTree.getLeafOfExample(dArray, n);
    }

    public final int getDepthSum(int subRoot, int curDepth) {
        return this.isLeaf(subRoot) ? curDepth : this.getDepthSum(this.leftChild[subRoot], curDepth + 1) + this.getDepthSum(this.rightChild[subRoot], curDepth + 1);
    }

    public static /* synthetic */ int getDepthSum$default(DecisionTree decisionTree, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = decisionTree.root;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return decisionTree.getDepthSum(n, n2);
    }

    public final int getMinDepth(int subRoot, int curDepth) {
        return this.isLeaf(subRoot) ? curDepth : Math.min(this.getMinDepth(this.leftChild[subRoot], curDepth + 1), this.getMinDepth(this.rightChild[subRoot], curDepth + 1));
    }

    public static /* synthetic */ int getMinDepth$default(DecisionTree decisionTree, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = decisionTree.root;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return decisionTree.getMinDepth(n, n2);
    }

    public final int getMaxDepth(int subRoot, int curDepth) {
        return this.isLeaf(subRoot) ? curDepth : Math.max(this.getMaxDepth(this.leftChild[subRoot], curDepth + 1), this.getMaxDepth(this.rightChild[subRoot], curDepth + 1));
    }

    public static /* synthetic */ int getMaxDepth$default(DecisionTree decisionTree, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = decisionTree.root;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return decisionTree.getMaxDepth(n, n2);
    }

    @NotNull
    public final String toFormattedString() {
        int n = 0;
        int n2 = this.vertexCount;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3;
            nArray[n3] = n3 = n++;
        }
        return ArraysKt.joinToString$default(nArray, (CharSequence)"|", null, null, 0, null, (Function1)new Function1<Integer, CharSequence>(this){
            final /* synthetic */ DecisionTree this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(int v) {
                int p;
                int n = p = this.this$0.getRoot() == v ? -1 : this.this$0.getParent()[v];
                String side = this.this$0.getRoot() == v ? "-1" : (this.this$0.getLeftChild()[this.this$0.getParent()[v]] == v ? "l" : "r");
                return this.this$0.isLeaf(v) ? (CharSequence)(p + ":" + side + ":" + this.this$0.getCla()[v] + ":-1:-1") : (CharSequence)(p + ":" + side + ":-1:" + this.this$0.getDim()[v] + ":" + this.this$0.getThr()[v]);
            }
        }, 30, null);
    }

    public final void verifyDataStructure() {
        Function2 function2;
        boolean bl;
        HashSet<Integer> found = new HashSet<Integer>();
        Ref.ObjectRef<Function2<Integer, Integer, Unit>> checkSubtree = new Ref.ObjectRef<Function2<Integer, Integer, Unit>>();
        checkSubtree.element = new Function2<Integer, Integer, Unit>(found, this, checkSubtree){
            final /* synthetic */ HashSet<Integer> $found;
            final /* synthetic */ DecisionTree this$0;
            final /* synthetic */ Ref.ObjectRef<Function2<Integer, Integer, Unit>> $checkSubtree;
            {
                this.$found = $found;
                this.this$0 = $receiver;
                this.$checkSubtree = $checkSubtree;
                super(2);
            }

            public final void invoke(int p, int curRoot) {
                if (this.$found.contains(curRoot)) {
                    throw new IllegalStateException("DT is a DAG not a tree!");
                }
                this.$found.add(curRoot);
                if (this.this$0.getRoot() != curRoot) {
                    boolean bl;
                    boolean bl2 = bl = this.this$0.getParent()[curRoot] == p;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    boolean bl3 = bl = this.this$0.getLeftChild()[p] == curRoot || this.this$0.getRightChild()[p] == curRoot;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                }
                if (!this.this$0.isLeaf(curRoot)) {
                    Function2 function2;
                    Function2 function22;
                    if (this.$checkSubtree.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("checkSubtree");
                        function22 = null;
                    } else {
                        function22 = (Function2)this.$checkSubtree.element;
                    }
                    function22.invoke(curRoot, this.this$0.getLeftChild()[curRoot]);
                    if (this.$checkSubtree.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("checkSubtree");
                        function2 = null;
                    } else {
                        function2 = (Function2)this.$checkSubtree.element;
                    }
                    function2.invoke(curRoot, this.this$0.getRightChild()[curRoot]);
                }
            }
        };
        boolean bl2 = bl = this.root != -1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (checkSubtree.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("checkSubtree");
            function2 = null;
        } else {
            function2 = (Function2)checkSubtree.element;
        }
        function2.invoke(this.root, this.root);
        boolean bl3 = bl = found.size() == this.vertexCount;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int n = this.vertexCount;
        for (int v = 0; v < n; ++v) {
            boolean bl4 = found.contains(v);
            if (!_Assertions.ENABLED || bl4) continue;
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Ldatastructures/DecisionTree$Companion;", "", "()V", "createFromFormattedString", "Ldatastructures/DecisionTree;", "fString", "", "createFromWekaOutput", "file", "Ljava/io/File;", "createFromYaDTDOTOutput", "Code"})
    @SourceDebugExtension(value={"SMAP\nDecisionTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecisionTree.kt\ndatastructures/DecisionTree$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n1864#2,3:356\n1864#2,3:359\n*S KotlinDebug\n*F\n+ 1 DecisionTree.kt\ndatastructures/DecisionTree$Companion\n*L\n40#1:356,3\n53#1:359,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DecisionTree createFromFormattedString(@NotNull String fString) {
            int v22;
            List values2;
            String s;
            int vi;
            int n;
            Intrinsics.checkNotNullParameter(fString, "fString");
            String[] stringArray = new String[]{"|"};
            List segments = StringsKt.split$default((CharSequence)fString, stringArray, false, 0, 6, null);
            int innerCount = (segments.size() - 1) / 2;
            DecisionTree dt = new DecisionTree(innerCount);
            HashMap vertMap = new HashMap();
            int nextInner = 0;
            int nextLeaf = 0;
            nextLeaf = innerCount;
            Iterable $this$forEachIndexed$iv = segments;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                vi = n;
                boolean bl = false;
                String[] stringArray2 = new String[]{":"};
                values2 = StringsKt.split$default((CharSequence)s, stringArray2, false, 0, 6, null);
                v22 = 0;
                v22 = Intrinsics.areEqual(values2.get(2), "-1") ? nextInner++ : nextLeaf++;
                Integer n2 = vi;
                Integer n3 = v22;
                ((Map)vertMap).put(n2, n3);
            }
            $this$forEachIndexed$iv = segments;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                s = (String)item$iv;
                vi = n;
                boolean bl = false;
                String[] v22 = new String[]{":"};
                values2 = StringsKt.split$default((CharSequence)s, v22, false, 0, 6, null);
                Object v = vertMap.get(vi);
                Intrinsics.checkNotNull(v);
                v22 = ((Number)v).intValue();
                if (Intrinsics.areEqual(values2.get(0), "-1")) {
                    dt.getParent()[v22] = -1;
                    dt.setRoot(v22);
                } else {
                    int p;
                    Object v3 = vertMap.get(Integer.parseInt((String)values2.get(0)));
                    Intrinsics.checkNotNull(v3);
                    dt.getParent()[v22] = p = ((Number)v3).intValue();
                    if (Intrinsics.areEqual(values2.get(1), "l")) {
                        dt.getLeftChild()[p] = v22;
                    } else {
                        dt.getRightChild()[p] = v22;
                    }
                }
                if (Intrinsics.areEqual(values2.get(2), "-1")) {
                    dt.getDim()[v22] = Integer.parseInt((String)values2.get(3));
                    dt.getThr()[v22] = Double.parseDouble((String)values2.get(4));
                    continue;
                }
                dt.getCla()[v22] = Boolean.parseBoolean((String)values2.get(2));
            }
            return dt;
        }

        @NotNull
        public final DecisionTree createFromYaDTDOTOutput(@NotNull File file) {
            List splits;
            Intrinsics.checkNotNullParameter(file, "file");
            List<String> lines = CollectionsKt.toMutableList(FilesKt.readLines$default(file, null, 1, null));
            CollectionsKt.removeFirst(lines);
            CollectionsKt.removeLast(lines);
            LinkedList<String> vertexLines = new LinkedList<String>();
            LinkedList<String> edgeLines = new LinkedList<String>();
            for (String line : lines) {
                String[] stringArray = new String[]{" "};
                if (Intrinsics.areEqual(StringsKt.split$default((CharSequence)line, stringArray, false, 0, 6, null).get(1), "->")) {
                    edgeLines.add(line);
                    continue;
                }
                vertexLines.add(line);
            }
            int vertexCount = vertexLines.size();
            DecisionTree dt = new DecisionTree((vertexCount - 1) / 2);
            int nextInner = 0;
            int nextLeaf = (vertexCount - 1) / 2;
            HashMap vertMap = new HashMap();
            for (String vertex : vertexLines) {
                Integer n;
                Intrinsics.checkNotNull(vertex);
                String[] stringArray = new String[]{" "};
                splits = StringsKt.split$default((CharSequence)vertex, stringArray, false, 0, 6, null);
                String v = (String)splits.get(0);
                if (Intrinsics.areEqual(splits.get(2), "shape=box,")) {
                    n = nextInner;
                    ((Map)vertMap).put(v, n);
                    dt.getDim()[nextInner] = Integer.parseInt(StringsKt.removeSuffix(StringsKt.removePrefix((String)splits.get(3), (CharSequence)"label=\""), (CharSequence)"\\n\"]")) - 1;
                    ++nextInner;
                    continue;
                }
                n = nextLeaf;
                ((Map)vertMap).put(v, n);
                dt.getCla()[nextLeaf] = StringsKt.startsWith$default((String)splits.get(3), "label=\"1", false, 2, null);
                ++nextLeaf;
            }
            for (String edge : edgeLines) {
                Intrinsics.checkNotNull(edge);
                String[] v = new String[]{" "};
                splits = StringsKt.split$default((CharSequence)edge, v, false, 0, 6, null);
                Object v2 = vertMap.get(splits.get(0));
                Intrinsics.checkNotNull(v2);
                int v1 = ((Number)v2).intValue();
                Object v3 = vertMap.get(splits.get(2));
                Intrinsics.checkNotNull(v3);
                int v22 = ((Number)v3).intValue();
                dt.getParent()[v22] = v1;
                String thr = StringsKt.removeSuffix(StringsKt.removePrefix((String)splits.get(3), (CharSequence)"[label=\""), (CharSequence)"\"]");
                if (StringsKt.startsWith$default(thr, "<=", false, 2, null)) {
                    dt.getLeftChild()[v1] = v22;
                    dt.getThr()[v1] = Double.parseDouble(StringsKt.removePrefix(thr, (CharSequence)"<="));
                    continue;
                }
                if (StringsKt.startsWith$default(thr, ">", false, 2, null)) {
                    dt.getRightChild()[v1] = v22;
                    dt.getThr()[v1] = Double.parseDouble(StringsKt.removePrefix(thr, (CharSequence)">"));
                    continue;
                }
                double curThr = Double.parseDouble(thr);
                if (dt.getLeftChild()[v1] != -1) {
                    double prevThr = dt.getThr()[v1];
                    if (prevThr < curThr) {
                        dt.getRightChild()[v1] = v22;
                        continue;
                    }
                    dt.getThr()[v1] = curThr;
                    dt.getRightChild()[v1] = dt.getLeftChild()[v1];
                    dt.getLeftChild()[v1] = v22;
                    continue;
                }
                dt.getLeftChild()[v1] = v22;
                dt.getThr()[v1] = curThr;
            }
            dt.setRoot(0);
            int n = dt.getInnerCount();
            for (int v = 0; v < n; ++v) {
                if (dt.getParent()[v] != -1) continue;
                dt.setRoot(v);
                break;
            }
            return dt;
        }

        @NotNull
        public final DecisionTree createFromWekaOutput(@NotNull File file) {
            Intrinsics.checkNotNullParameter(file, "file");
            List lines = CollectionsKt.toMutableList(FilesKt.readLines$default(file, null, 1, null));
            while (!StringsKt.startsWith$default((String)CollectionsKt.first(lines), "------------------", false, 2, null)) {
                CollectionsKt.removeFirst(lines);
            }
            CollectionsKt.removeFirst(lines);
            CollectionsKt.removeFirst(lines);
            LinkedList treeLines = new LinkedList();
            while (!StringsKt.startsWith$default((String)CollectionsKt.first(lines), "Number of Leaves", false, 2, null)) {
                treeLines.add(CollectionsKt.removeFirst(lines));
            }
            treeLines.removeLast();
            int leafCount = Integer.parseInt(((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix(((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix(((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first(lines)))).toString(), (CharSequence)"Number of Leaves"))).toString(), (CharSequence)":"))).toString());
            int innerCount = leafCount - 1;
            DecisionTree dt = new DecisionTree(innerCount);
            dt.setRoot(0);
            int nextInner = 1;
            int nextLeaf = innerCount;
            LinkedList<Integer> curRootPath = new LinkedList<Integer>();
            curRootPath.addLast(0);
            while (!((Collection)treeLines).isEmpty()) {
                String[] stringArray;
                String[] curLine = (String[])treeLines.removeFirst();
                int curDepth = 0;
                while (true) {
                    stringArray = curLine;
                    Intrinsics.checkNotNull(stringArray);
                    if (!StringsKt.startsWith$default((String)stringArray, " ", false, 2, null)) {
                        stringArray = curLine;
                        Intrinsics.checkNotNull(stringArray);
                        if (!StringsKt.startsWith$default((String)stringArray, "|", false, 2, null)) break;
                    }
                    stringArray = curLine;
                    Intrinsics.checkNotNull(stringArray);
                    stringArray = curLine = ((Object)StringsKt.trim((CharSequence)stringArray)).toString();
                    Intrinsics.checkNotNull(stringArray);
                    if (!StringsKt.startsWith$default((String)stringArray, "|", false, 2, null)) continue;
                    stringArray = curLine;
                    Intrinsics.checkNotNull(stringArray);
                    curLine = StringsKt.removePrefix((String)stringArray, (CharSequence)"|");
                    ++curDepth;
                }
                stringArray = curLine;
                Intrinsics.checkNotNull(stringArray);
                curLine = ((Object)StringsKt.trim((CharSequence)stringArray)).toString();
                while (curRootPath.size() > curDepth + 1) {
                    curRootPath.removeLast();
                }
                Integer p = (Integer)curRootPath.getLast();
                int v = 0;
                String[] stringArray2 = curLine;
                Intrinsics.checkNotNull(stringArray2);
                if (StringsKt.endsWith$default((String)stringArray2, ")", false, 2, null)) {
                    v = nextLeaf++;
                    boolean[] blArray = dt.getCla();
                    stringArray2 = curLine;
                    Intrinsics.checkNotNull(stringArray2);
                    CharSequence charSequence = (CharSequence)stringArray2;
                    stringArray2 = new String[]{"("};
                    CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)((String)StringsKt.split$default(charSequence, stringArray2, false, 0, 6, null).get(0)))).toString();
                    stringArray2 = new String[]{" "};
                    blArray[v] = Intrinsics.areEqual(CollectionsKt.last(StringsKt.split$default(charSequence2, stringArray2, false, 0, 6, null)), "1");
                } else {
                    v = nextInner++;
                }
                int[] nArray = dt.getDim();
                Intrinsics.checkNotNull(p);
                int n = p;
                stringArray2 = curLine;
                Intrinsics.checkNotNull(stringArray2);
                CharSequence charSequence = (CharSequence)stringArray2;
                stringArray2 = new String[]{" "};
                nArray[n] = Integer.parseInt(StringsKt.removePrefix((String)StringsKt.split$default(charSequence, stringArray2, false, 0, 6, null).get(0), (CharSequence)"d")) - 1;
                double[] dArray = dt.getThr();
                int n2 = p;
                stringArray2 = curLine;
                Intrinsics.checkNotNull(stringArray2);
                CharSequence charSequence3 = (CharSequence)stringArray2;
                stringArray2 = new String[]{" "};
                dArray[n2] = Double.parseDouble(StringsKt.removeSuffix((String)StringsKt.split$default(charSequence3, stringArray2, false, 0, 6, null).get(2), (CharSequence)":"));
                dt.getParent()[v] = p;
                stringArray2 = curLine;
                Intrinsics.checkNotNull(stringArray2);
                if (StringsKt.contains$default((CharSequence)stringArray2, "<=", false, 2, null)) {
                    dt.getLeftChild()[p.intValue()] = v;
                } else {
                    dt.getRightChild()[p.intValue()] = v;
                }
                curRootPath.addLast(v);
            }
            return dt;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

