/*
 * Decompiled with CFR 0.152.
 */
package lowerbounds;

import datastructures.NormalizedDataSet;
import gurobi.GRB;
import gurobi.GRBConstr;
import gurobi.GRBEnv;
import gurobi.GRBLinExpr;
import gurobi.GRBModel;
import gurobi.GRBVar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import lowerbounds.PairLB;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0018H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006\u001d"}, d2={"Llowerbounds/PairLB6;", "Llowerbounds/PairLB;", "env", "Lgurobi/GRBEnv;", "data", "Ldatastructures/NormalizedDataSet;", "(Lgurobi/GRBEnv;Ldatastructures/NormalizedDataSet;)V", "addedPairsLastUpdate", "", "delta", "", "model", "Lgurobi/GRBModel;", "kotlin.jvm.PlatformType", "objConstr", "Lgurobi/GRBConstr;", "pairLinExpr", "", "Lgurobi/GRBLinExpr;", "[Lgurobi/GRBLinExpr;", "variables", "Lgurobi/GRBVar;", "[Lgurobi/GRBVar;", "calcLowerBound", "", "maxLB", "dispose", "", "updateChangedConstraints", "Code"})
public final class PairLB6
extends PairLB {
    private final double delta;
    private final GRBModel model;
    @NotNull
    private final GRBVar[] variables;
    @NotNull
    private final GRBLinExpr[] pairLinExpr;
    @NotNull
    private final boolean[] addedPairsLastUpdate;
    @NotNull
    private final GRBConstr objConstr;

    public PairLB6(@NotNull GRBEnv env, @NotNull NormalizedDataSet data) {
        int n;
        Intrinsics.checkNotNullParameter(env, "env");
        Intrinsics.checkNotNullParameter(data, "data");
        super(data);
        this.delta = 1.0E-5;
        this.model = new GRBModel(env).feasibility();
        this.model.set(GRB.IntParam.Threads, 1);
        this.model.set(GRB.IntParam.Presolve, 0);
        GRBLinExpr obj = new GRBLinExpr();
        int n2 = 0;
        int n3 = this.getRefinementCount();
        Object[] objectArray = new GRBVar[n3];
        PairLB6 pairLB6 = this;
        while (n2 < n3) {
            n = n2++;
            GRBVar variable = this.model.addVar(0.0, 1.0, 1.0, 'C', String.valueOf(n));
            obj.addTerm(1.0, variable);
            Intrinsics.checkNotNull(variable);
            objectArray[n] = variable;
        }
        pairLB6.variables = objectArray;
        this.model.update();
        GRBConstr gRBConstr = this.model.addConstr(obj, '<', 0.0, "obj");
        Intrinsics.checkNotNullExpressionValue(gRBConstr, "addConstr(...)");
        this.objConstr = gRBConstr;
        this.model.update();
        n2 = 0;
        n3 = this.getPairCount();
        objectArray = new boolean[n3];
        pairLB6 = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = (GRBVar)false;
        }
        pairLB6.addedPairsLastUpdate = (boolean[])objectArray;
        n2 = 0;
        n3 = this.getPairCount();
        objectArray = new GRBLinExpr[n3];
        pairLB6 = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = new GRBLinExpr();
        }
        pairLB6.pairLinExpr = objectArray;
        n3 = this.getPairCount();
        for (int pairId = 0; pairId < n3; ++pairId) {
            GRBLinExpr linExpr = this.pairLinExpr[pairId];
            for (Integer refinementId : this.getPairNeighbors()[pairId]) {
                Intrinsics.checkNotNull(refinementId);
                linExpr.addTerm(1.0, this.variables[refinementId]);
            }
        }
    }

    private final void updateChangedConstraints(int maxLB) {
        int n = this.addedPairsLastUpdate.length;
        for (int id = 0; id < n; ++id) {
            if (this.getExistingPairs()[id] == this.addedPairsLastUpdate[id]) continue;
            if (this.getExistingPairs()[id]) {
                this.model.addConstr(this.pairLinExpr[id], '>', 1.0, String.valueOf(id));
            } else {
                this.model.remove(this.model.getConstrByName(String.valueOf(id)));
            }
            this.addedPairsLastUpdate[id] = this.getExistingPairs()[id];
        }
    }

    @Override
    public int calcLowerBound(int maxLB) {
        this.updateChangedConstraints(maxLB);
        this.objConstr.set(GRB.DoubleAttr.RHS, (double)maxLB);
        this.model.optimize();
        return this.model.get(GRB.IntAttr.Status) == 3 ? maxLB + 1 : maxLB;
    }

    public final void dispose() {
        this.model.dispose();
    }
}

