/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010(\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0006\u0010\u000e\u001a\u00020\fJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0012\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0016J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0000J\u0011\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0086\u0002J\u0006\u0010\u0018\u001a\u00020\u0002J\u0006\u0010\u0019\u001a\u00020\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0096\u0002J\u0006\u0010\u001d\u001a\u00020\u0002J\u0006\u0010\u001e\u001a\u00020\fJ\u0006\u0010\u001f\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Ldatastructures/FixedSizeArrayList;", "", "", "maxSize", "(I)V", "array", "", "curSize", "size", "getSize", "()I", "add", "", "elem", "clear", "contains", "", "element", "containsAll", "elements", "copyInto", "other", "get", "i", "getFirst", "getLast", "isEmpty", "iterator", "", "removeLast", "sort", "sortDescending", "Code"})
public final class FixedSizeArrayList
implements Collection<Integer>,
KMappedMarker {
    private final int maxSize;
    @NotNull
    private final int[] array;
    private int curSize;

    public FixedSizeArrayList(int maxSize) {
        this.maxSize = maxSize;
        this.array = new int[this.maxSize];
    }

    public int getSize() {
        return this.curSize;
    }

    @Override
    public boolean isEmpty() {
        return this.curSize == 0;
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        Iterator<? extends Object> iterator2 = elements.iterator();
        while (iterator2.hasNext()) {
            int e = ((Number)iterator2.next()).intValue();
            if (this.contains((Object)e)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int element) {
        Iterator<Integer> iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            int e = ((Number)iterator2.next()).intValue();
            if (e != element) continue;
            return true;
        }
        return false;
    }

    public final int getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.array[0];
    }

    public final int getLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.array[this.curSize - 1];
    }

    public final int get(int i) {
        if (i < 0 || this.curSize <= i) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[i];
    }

    public final void add(int elem) {
        if (this.curSize == this.maxSize) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.array[this.curSize] = elem;
        int n = this.curSize;
        this.curSize = n + 1;
    }

    public final int removeLast() {
        if (this.curSize == 0) {
            throw new NoSuchElementException();
        }
        int n = this.curSize;
        this.curSize = n + -1;
        return this.array[this.curSize];
    }

    @Override
    public final void clear() {
        this.curSize = 0;
    }

    public final void copyInto(@NotNull FixedSizeArrayList other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (other.maxSize < this.maxSize) {
            throw new IllegalArgumentException();
        }
        other.curSize = this.curSize;
        ArraysKt.copyInto$default(this.array, other.array, 0, 0, this.curSize, 6, null);
    }

    public final void sort() {
        ArraysKt.sort(this.array, 0, this.curSize);
    }

    public final void sortDescending() {
        ArraysKt.sortDescending(this.array, 0, this.curSize);
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(this){
            private int nextIndex;
            final /* synthetic */ FixedSizeArrayList this$0;
            {
                this.this$0 = $receiver;
            }

            public final int getNextIndex() {
                return this.nextIndex;
            }

            public final void setNextIndex(int n) {
                this.nextIndex = n;
            }

            public boolean hasNext() {
                return this.nextIndex < FixedSizeArrayList.access$getCurSize$p(this.this$0);
            }

            @NotNull
            public Integer next() {
                int n = this.nextIndex;
                this.nextIndex = n + 1;
                return FixedSizeArrayList.access$getArray$p(this.this$0)[this.nextIndex - 1];
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @Override
    public boolean add(int element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends Integer> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeIf(Predicate<? super Integer> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public static final /* synthetic */ int access$getCurSize$p(FixedSizeArrayList $this) {
        return $this.curSize;
    }

    public static final /* synthetic */ int[] access$getArray$p(FixedSizeArrayList $this) {
        return $this.array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        return CollectionToArray.toArray(this, array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray(this);
    }
}

