/*
 * Decompiled with CFR 0.152.
 */
package gurobi;

import gurobi.GRB;
import gurobi.GRBException;
import gurobi.GRBExpr;
import gurobi.GRBLinExpr;
import gurobi.GRBVar;
import java.util.ArrayList;

public class GRBQuadExpr
extends GRBExpr {
    GRBLinExpr linexpr;
    ArrayList<Double> coeffs;
    ArrayList<GRBVar> vars1;
    ArrayList<GRBVar> vars2;

    protected void finalize() {
    }

    public GRBQuadExpr() {
        this.linexpr = new GRBLinExpr();
        this.coeffs = new ArrayList();
        this.vars1 = new ArrayList();
        this.vars2 = new ArrayList();
    }

    public GRBQuadExpr(GRBLinExpr le) throws GRBException {
        this.linexpr = new GRBLinExpr(le);
        this.coeffs = new ArrayList();
        this.vars1 = new ArrayList();
        this.vars2 = new ArrayList();
    }

    public GRBQuadExpr(GRBQuadExpr qe) throws GRBException {
        this.linexpr = new GRBLinExpr();
        this.coeffs = new ArrayList();
        this.vars1 = new ArrayList();
        this.vars2 = new ArrayList();
        this.add(qe);
    }

    public int size() {
        return this.coeffs.size();
    }

    public GRBVar getVar1(int i) throws GRBException {
        if (i < 0 || i >= this.coeffs.size()) {
            throw new GRBException("Index i out of range", 10006);
        }
        return this.vars1.get(i);
    }

    public GRBVar getVar2(int i) throws GRBException {
        if (i < 0 || i >= this.coeffs.size()) {
            throw new GRBException("Index i out of range", 10006);
        }
        return this.vars2.get(i);
    }

    public double getCoeff(int i) throws GRBException {
        if (i < 0 || i >= this.coeffs.size()) {
            throw new GRBException("Index i out of range", 10006);
        }
        return this.coeffs.get(i);
    }

    public GRBLinExpr getLinExpr() {
        return this.linexpr;
    }

    public double getValue() throws GRBException {
        double value = this.linexpr.getValue();
        for (int i = 0; i < this.coeffs.size(); ++i) {
            value += this.coeffs.get(i) * this.vars1.get(i).get(GRB.DoubleAttr.X) * this.vars2.get(i).get(GRB.DoubleAttr.X);
        }
        return value;
    }

    public void addConstant(double c) {
        this.linexpr.addConstant(c);
    }

    public void addTerm(double coeff, GRBVar var) {
        this.linexpr.addTerm(coeff, var);
    }

    public void addTerm(double coeff, GRBVar var1, GRBVar var2) {
        this.coeffs.add(coeff);
        this.vars1.add(var1);
        this.vars2.add(var2);
    }

    public void addTerms(double[] coeff, GRBVar[] var) throws GRBException {
        if (var == null) {
            return;
        }
        this.addTerms(coeff, var, 0, var.length);
    }

    public void addTerms(double[] coeff, GRBVar[] var1, GRBVar[] var2) throws GRBException {
        if (var1 == null || var2 == null) {
            return;
        }
        this.addTerms(coeff, var1, var2, 0, var1.length);
    }

    public void addTerms(double[] coeff, GRBVar[] var, int start, int len) throws GRBException {
        this.linexpr.addTerms(coeff, var, start, len);
    }

    public void addTerms(double[] coeff, GRBVar[] var1, GRBVar[] var2, int start, int len) throws GRBException {
        int last = start + len;
        if (start < 0 || coeff != null && last > coeff.length || var1 == null || var2 == null || last > var1.length) {
            throw new GRBException("Invalid arguments", 10003);
        }
        for (int i = start; i < last; ++i) {
            if (coeff == null) {
                this.coeffs.add(1.0);
            } else {
                this.coeffs.add(coeff[i]);
            }
            this.vars1.add(var1[i]);
            this.vars2.add(var2[i]);
        }
    }

    public void add(GRBLinExpr le) throws GRBException {
        this.linexpr.add(le);
    }

    public void add(GRBQuadExpr qe) throws GRBException {
        this.multAdd(1.0, qe);
    }

    public void multAdd(double m, GRBLinExpr le) throws GRBException {
        this.linexpr.multAdd(m, le);
    }

    public void multAdd(double m, GRBQuadExpr qe) throws GRBException {
        ArrayList<GRBVar> addvars2;
        ArrayList<GRBVar> addvars1;
        ArrayList<Double> addcoeffs;
        if (m == 0.0) {
            return;
        }
        this.linexpr.multAdd(m, qe.getLinExpr());
        if (this.coeffs == qe.coeffs) {
            addcoeffs = new ArrayList<Double>(qe.coeffs);
            addvars1 = new ArrayList<GRBVar>(qe.vars1);
            addvars2 = new ArrayList<GRBVar>(qe.vars2);
        } else {
            addcoeffs = qe.coeffs;
            addvars1 = qe.vars1;
            addvars2 = qe.vars2;
        }
        if (m == 1.0) {
            this.coeffs.addAll(addcoeffs);
        } else {
            int size = qe.size();
            for (int i = 0; i < size; ++i) {
                this.coeffs.add(m * addcoeffs.get(i));
            }
        }
        this.vars1.addAll(addvars1);
        this.vars2.addAll(addvars2);
    }

    public void remove(int i) {
        if (i >= 0 && i < this.coeffs.size()) {
            this.coeffs.remove(i);
            this.vars1.remove(i);
            this.vars2.remove(i);
        }
    }

    public boolean remove(GRBVar v) {
        int size = this.coeffs.size();
        for (int i = size - 1; i >= 0; --i) {
            if (v != this.vars1.get(i) && v != this.vars2.get(i)) continue;
            this.coeffs.remove(i);
            this.vars1.remove(i);
            this.vars2.remove(i);
        }
        boolean ret = this.linexpr.remove(v);
        return ret || size > this.coeffs.size();
    }

    public void clear() {
        this.linexpr.clear();
        this.coeffs.clear();
        this.vars1.clear();
        this.vars2.clear();
    }
}

