/*
 * Decompiled with CFR 0.152.
 */
package gurobi;

import gurobi.GRB;
import gurobi.GRBCObj;
import gurobi.GRBException;
import gurobi.GurobiJni;

public class GRBSOS {
    private GRBCObj Cmodel = null;
    private long model;
    private int num;

    GRBSOS() {
        this.num = -2;
        this.model = 0L;
    }

    GRBSOS(GRBCObj XCmodel, int sos) {
        this.Cmodel = XCmodel;
        this.model = XCmodel.get();
        this.num = sos;
    }

    protected void finalize() {
    }

    void setindex(int sos) {
        this.num = sos;
    }

    int getindex() {
        return this.num;
    }

    public int get(GRB.IntAttr attr) throws GRBException {
        if (this.num < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 3);
        if (error != 0) {
            throw new GRBException("Not SOS attribute", error);
        }
        int[] ind = new int[1];
        int[] value = new int[1];
        error = GurobiJni.getintattrlist(this.model, attr.toString(), this.num, 0, ind, value);
        if (error != 0) {
            throw new GRBException("Error at GRBSOS.get", error);
        }
        return value[0];
    }

    public void set(GRB.IntAttr attr, int newval) throws GRBException {
        if (this.num < 0 || this.model == 0L) {
            throw new GRBException(20001);
        }
        int error = GRB.checkattrsize(this.model, attr.toString(), 3);
        if (error != 0) {
            throw new GRBException("Not SOS attribute", error);
        }
        int[] ind = new int[1];
        int[] tmp = new int[]{newval};
        error = GurobiJni.setintattrlist(this.model, attr.toString(), this.num, 0, ind, tmp);
        if (error != 0) {
            throw new GRBException("Error at GRBSOS.set", error);
        }
    }
}

