/*
 * Decompiled with CFR 0.152.
 */
package lowerbounds;

import datastructures.MultiLinkedList;
import java.util.Collection;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J0\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0016\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bJ(\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u001c\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Llowerbounds/ImpLB;", "", "w", "LWitnessTree;", "(LWitnessTree;)V", "maxImpSizes", "", "Ljava/util/PriorityQueue;", "", "[Ljava/util/PriorityQueue;", "maxImpSizesSum", "", "addImpToQueue", "", "imp", "subRoot", "remaining", "calcImpInSubtree", "dim", "bound", "countLeftSide", "", "cla", "calcImpLowerBound", "curRoot", "maxLB", "calcMaxImpSizesInSubtree", "totalRoot", "curClass", "removeLastImpFromQueue", "Code"})
@SourceDebugExtension(value={"SMAP\nImpLB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImpLB.kt\nlowerbounds/ImpLB\n+ 2 MultiLinkedList.kt\ndatastructures/MultiLinkedList\n*L\n1#1,157:1\n152#2,6:158\n*S KotlinDebug\n*F\n+ 1 ImpLB.kt\nlowerbounds/ImpLB\n*L\n60#1:158,6\n*E\n"})
public final class ImpLB {
    @NotNull
    private final WitnessTree w;
    @NotNull
    private final PriorityQueue<Integer>[] maxImpSizes;
    @NotNull
    private int[] maxImpSizesSum;

    public ImpLB(@NotNull WitnessTree w) {
        Intrinsics.checkNotNullParameter(w, "w");
        this.w = w;
        int n = 0;
        int n2 = this.w.getMaxVertexCount();
        PriorityQueue[] priorityQueueArray = new PriorityQueue[n2];
        ImpLB impLB = this;
        while (n < n2) {
            int n3 = n++;
            priorityQueueArray[n3] = new PriorityQueue();
        }
        impLB.maxImpSizes = priorityQueueArray;
        this.maxImpSizesSum = new int[this.w.getMaxVertexCount()];
    }

    public final int calcImpLowerBound(int curRoot, int maxLB) {
        this.w.updateDirtyThresholds(curRoot);
        this.w.updateWitnessThresholds(curRoot);
        this.calcMaxImpSizesInSubtree(curRoot, curRoot, true, maxLB + 1);
        int lbTrue = this.maxImpSizes[curRoot].size();
        if (lbTrue > maxLB) {
            return lbTrue;
        }
        int newRemaining = maxLB - lbTrue;
        this.calcMaxImpSizesInSubtree(curRoot, curRoot, false, newRemaining + 1);
        return lbTrue + this.maxImpSizes[curRoot].size();
    }

    private final void addImpToQueue(int imp, int subRoot, int remaining) {
        this.maxImpSizes[subRoot].add(imp);
        int[] nArray = this.maxImpSizesSum;
        nArray[subRoot] = nArray[subRoot] + imp;
        if (this.maxImpSizes[subRoot].size() > remaining) {
            this.removeLastImpFromQueue(subRoot);
        }
    }

    private final void removeLastImpFromQueue(int subRoot) {
        int[] nArray = this.maxImpSizesSum;
        int n = nArray[subRoot];
        Integer n2 = this.maxImpSizes[subRoot].poll();
        Intrinsics.checkNotNullExpressionValue(n2, "poll(...)");
        nArray[subRoot] = n - ((Number)n2).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final int calcImpInSubtree(int subRoot, int dim, int bound, boolean countLeftSide, boolean cla) {
        int n;
        if (this.w.isLeaf(subRoot)) {
            if (this.w.getCla()[subRoot] == cla) {
                n = 0;
            } else {
                void this_$iv;
                int count = 0;
                MultiLinkedList multiLinkedList = this.w.getELists();
                int list$iv = this.w.getDirtyList()[subRoot];
                boolean $i$f$forEach = false;
                int nextElem$iv = this_$iv.getHead(list$iv);
                while (nextElem$iv != -1) {
                    int curE = nextElem$iv;
                    boolean bl = false;
                    if (countLeftSide && this.w.getData().getValues()[curE][dim] < bound) {
                        ++count;
                    }
                    if (!countLeftSide && this.w.getData().getValues()[curE][dim] > bound) {
                        ++count;
                    }
                    nextElem$iv = this_$iv.getNext(nextElem$iv);
                }
                n = count;
            }
        } else {
            n = this.calcImpInSubtree(this.w.getLeftChild()[subRoot], dim, bound, countLeftSide, cla) + this.calcImpInSubtree(this.w.getRightChild()[subRoot], dim, bound, countLeftSide, cla);
        }
        return n;
    }

    private final int calcMaxImpSizesInSubtree(int totalRoot, int subRoot, boolean curClass, int remaining) {
        int count = 0;
        this.maxImpSizes[subRoot].clear();
        this.maxImpSizesSum[subRoot] = 0;
        if (this.w.isLeaf(subRoot)) {
            if (this.w.getCla()[subRoot] != curClass) {
                count += this.w.getELists().getSize(this.w.getDirtyList()[subRoot]);
            }
        } else {
            count += this.calcMaxImpSizesInSubtree(totalRoot, this.w.getLeftChild()[subRoot], curClass, remaining);
            count += this.calcMaxImpSizesInSubtree(totalRoot, this.w.getRightChild()[subRoot], curClass, remaining);
        }
        if (count == 0) {
            return 0;
        }
        int n = this.w.getData().getD();
        for (int dim = 0; dim < n; ++dim) {
            int imp;
            boolean calcRight;
            boolean calcLeft = subRoot == totalRoot || this.w.getLeftWitThr()[dim][subRoot] != this.w.getLeftWitThr()[dim][this.w.getParent()[subRoot]];
            boolean bl = calcRight = subRoot == totalRoot || this.w.getRightWitThr()[dim][subRoot] != this.w.getRightWitThr()[dim][this.w.getParent()[subRoot]];
            if (curClass) {
                if (calcLeft && this.w.getLeftDirtyThrTrue()[dim][subRoot] < this.w.getLeftWitThr()[dim][subRoot]) {
                    imp = this.calcImpInSubtree(subRoot, dim, this.w.getLeftWitThr()[dim][subRoot], true, true);
                    this.addImpToQueue(imp, subRoot, remaining);
                }
                if (!calcRight || this.w.getRightDirtyThrTrue()[dim][subRoot] <= this.w.getRightWitThr()[dim][subRoot]) continue;
                imp = this.calcImpInSubtree(subRoot, dim, this.w.getRightWitThr()[dim][subRoot], false, true);
                this.addImpToQueue(imp, subRoot, remaining);
                continue;
            }
            if (calcLeft && this.w.getLeftDirtyThrFalse()[dim][subRoot] < this.w.getLeftWitThr()[dim][subRoot]) {
                imp = this.calcImpInSubtree(subRoot, dim, this.w.getLeftWitThr()[dim][subRoot], true, false);
                this.addImpToQueue(imp, subRoot, remaining);
            }
            if (!calcRight || this.w.getRightDirtyThrFalse()[dim][subRoot] <= this.w.getRightWitThr()[dim][subRoot]) continue;
            imp = this.calcImpInSubtree(subRoot, dim, this.w.getRightWitThr()[dim][subRoot], false, false);
            this.addImpToQueue(imp, subRoot, remaining);
        }
        if (!this.w.isLeaf(subRoot)) {
            PriorityQueue<Integer> leftQueue = this.maxImpSizes[this.w.getLeftChild()[subRoot]];
            PriorityQueue<Integer> rightQueue = this.maxImpSizes[this.w.getRightChild()[subRoot]];
            for (Integer imp : leftQueue) {
                Intrinsics.checkNotNull(imp);
                this.addImpToQueue(imp, subRoot, remaining);
            }
            leftQueue.clear();
            for (Integer imp : rightQueue) {
                Intrinsics.checkNotNull(imp);
                this.addImpToQueue(imp, subRoot, remaining);
            }
            rightQueue.clear();
        }
        while (!((Collection)this.maxImpSizes[subRoot]).isEmpty()) {
            int n2 = this.maxImpSizesSum[subRoot];
            Integer n3 = this.maxImpSizes[subRoot].peek();
            Intrinsics.checkNotNullExpressionValue(n3, "peek(...)");
            if (n2 - ((Number)n3).intValue() < count) break;
            this.removeLastImpFromQueue(subRoot);
        }
        if (this.maxImpSizesSum[subRoot] > count) {
            int diff = this.maxImpSizesSum[subRoot] - count;
            this.maxImpSizes[subRoot].add(((Number)this.maxImpSizes[subRoot].poll()).intValue() - diff);
            this.maxImpSizesSum[subRoot] = count;
        }
        return count;
    }
}

