/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.BIFReader;
import weka.classifiers.bayes.net.ParentSet;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class MarginCalculator
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 650278019241175534L;
    boolean m_debug = false;
    public JunctionTreeNode m_root = null;
    JunctionTreeNode[] jtNodes;
    double[][] m_Margins;

    public int getNode(String sNodeName) {
        for (int iNode = 0; iNode < this.m_root.m_bayesNet.m_Instances.numAttributes(); ++iNode) {
            if (!this.m_root.m_bayesNet.m_Instances.attribute(iNode).name().equals(sNodeName)) continue;
            return iNode;
        }
        return -1;
    }

    public String toXMLBIF03() {
        return this.m_root.m_bayesNet.toXMLBIF03();
    }

    public void calcMargins(BayesNet bayesNet) throws Exception {
        boolean[][] bAdjacencyMatrix = this.moralize(bayesNet);
        this.process(bAdjacencyMatrix, bayesNet);
    }

    public void calcFullMargins(BayesNet bayesNet) throws Exception {
        int nNodes = bayesNet.getNrOfNodes();
        boolean[][] bAdjacencyMatrix = new boolean[nNodes][nNodes];
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            for (int iNode2 = 0; iNode2 < nNodes; ++iNode2) {
                bAdjacencyMatrix[iNode][iNode2] = true;
            }
        }
        this.process(bAdjacencyMatrix, bayesNet);
    }

    public void process(boolean[][] bAdjacencyMatrix, BayesNet bayesNet) throws Exception {
        int iNode;
        int i;
        int[] order = this.getMaxCardOrder(bAdjacencyMatrix);
        bAdjacencyMatrix = this.fillIn(order, bAdjacencyMatrix);
        order = this.getMaxCardOrder(bAdjacencyMatrix);
        Set<Integer>[] cliques = this.getCliques(order, bAdjacencyMatrix);
        Set<Integer>[] separators = this.getSeparators(order, cliques);
        int[] parentCliques = this.getCliqueTree(order, cliques, separators);
        int nNodes = bAdjacencyMatrix.length;
        if (this.m_debug) {
            for (i = 0; i < nNodes; ++i) {
                int iNode2;
                iNode = order[i];
                if (cliques[iNode] == null) continue;
                System.out.print("Clique " + iNode + " (");
                Iterator<Integer> nodes = cliques[iNode].iterator();
                while (nodes.hasNext()) {
                    iNode2 = nodes.next();
                    System.out.print(iNode2 + " " + bayesNet.getNodeName(iNode2));
                    if (!nodes.hasNext()) continue;
                    System.out.print(",");
                }
                System.out.print(") S(");
                nodes = separators[iNode].iterator();
                while (nodes.hasNext()) {
                    iNode2 = nodes.next();
                    System.out.print(iNode2 + " " + bayesNet.getNodeName(iNode2));
                    if (!nodes.hasNext()) continue;
                    System.out.print(",");
                }
                System.out.println(") parent clique " + parentCliques[iNode]);
            }
        }
        this.jtNodes = this.getJunctionTree(cliques, separators, parentCliques, order, bayesNet);
        this.m_root = null;
        for (int iNode2 = 0; iNode2 < nNodes; ++iNode2) {
            if (parentCliques[iNode2] >= 0 || this.jtNodes[iNode2] == null) continue;
            this.m_root = this.jtNodes[iNode2];
            break;
        }
        this.m_Margins = new double[nNodes][];
        this.initialize(this.jtNodes, order, cliques, separators, parentCliques);
        for (i = 0; i < nNodes; ++i) {
            iNode = order[i];
            if (cliques[iNode] == null || parentCliques[iNode] != -1 || separators[iNode].size() <= 0) continue;
            throw new Exception("Something wrong in clique tree");
        }
        if (this.m_debug) {
            // empty if block
        }
    }

    void initialize(JunctionTreeNode[] jtNodes, int[] order, Set<Integer>[] cliques, Set<Integer>[] separators, int[] parentCliques) {
        int iNode;
        int i;
        int nNodes = order.length;
        for (i = nNodes - 1; i >= 0; --i) {
            iNode = order[i];
            if (jtNodes[iNode] == null) continue;
            jtNodes[iNode].initializeUp();
        }
        for (i = 0; i < nNodes; ++i) {
            iNode = order[i];
            if (jtNodes[iNode] == null) continue;
            jtNodes[iNode].initializeDown(false);
        }
    }

    JunctionTreeNode[] getJunctionTree(Set<Integer>[] cliques, Set<Integer>[] separators, int[] parentCliques, int[] order, BayesNet bayesNet) {
        int iNode;
        int i;
        int nNodes = order.length;
        JunctionTreeNode[] jtns = new JunctionTreeNode[nNodes];
        boolean[] bDone = new boolean[nNodes];
        for (i = 0; i < nNodes; ++i) {
            iNode = order[i];
            if (cliques[iNode] == null) continue;
            jtns[iNode] = new JunctionTreeNode(cliques[iNode], bayesNet, bDone);
        }
        for (i = 0; i < nNodes; ++i) {
            iNode = order[i];
            if (cliques[iNode] == null) continue;
            JunctionTreeNode parent = null;
            if (parentCliques[iNode] <= 0) continue;
            parent = jtns[parentCliques[iNode]];
            JunctionTreeSeparator jts = new JunctionTreeSeparator(separators[iNode], bayesNet, jtns[iNode], parent);
            jtns[iNode].setParentSeparator(jts);
            jtns[parentCliques[iNode]].addChildClique(jtns[iNode]);
        }
        return jtns;
    }

    int getCPT(int[] nodeSet, int nNodes, int[] values, int[] order, BayesNet bayesNet) {
        int iCPTnew = 0;
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            int nNode = nodeSet[iNode];
            iCPTnew *= bayesNet.getCardinality(nNode);
            iCPTnew += values[order[nNode]];
        }
        return iCPTnew;
    }

    int[] getCliqueTree(int[] order, Set<Integer>[] cliques, Set<Integer>[] separators) {
        int nNodes = order.length;
        int[] parentCliques = new int[nNodes];
        for (int i = 0; i < nNodes; ++i) {
            int iNode = order[i];
            parentCliques[iNode] = -1;
            if (cliques[iNode] == null || separators[iNode].size() <= 0) continue;
            for (int j = 0; j < nNodes; ++j) {
                int iNode2 = order[j];
                if (iNode == iNode2 || cliques[iNode2] == null || !cliques[iNode2].containsAll(separators[iNode])) continue;
                parentCliques[iNode] = iNode2;
                j = i;
                j = 0;
                j = nNodes;
            }
        }
        return parentCliques;
    }

    Set<Integer>[] getSeparators(int[] order, Set<Integer>[] cliques) {
        int nNodes = order.length;
        HashSet[] separators = new HashSet[nNodes];
        HashSet<Integer> processedNodes = new HashSet<Integer>();
        for (int i = 0; i < nNodes; ++i) {
            int iNode = order[i];
            if (cliques[iNode] == null) continue;
            HashSet<Integer> separator = new HashSet<Integer>();
            separator.addAll(cliques[iNode]);
            separator.retainAll(processedNodes);
            separators[iNode] = separator;
            processedNodes.addAll(cliques[iNode]);
        }
        return separators;
    }

    Set<Integer>[] getCliques(int[] order, boolean[][] bAdjacencyMatrix) throws Exception {
        int iNode;
        int nNodes = bAdjacencyMatrix.length;
        HashSet[] cliques = new HashSet[nNodes];
        for (int i = nNodes - 1; i >= 0; --i) {
            iNode = order[i];
            if (iNode == 22) {
                // empty if block
            }
            HashSet<Integer> clique = new HashSet<Integer>();
            clique.add(iNode);
            for (int j = 0; j < i; ++j) {
                int iNode2 = order[j];
                if (!bAdjacencyMatrix[iNode][iNode2]) continue;
                clique.add(iNode2);
            }
            cliques[iNode] = clique;
        }
        for (int iNode2 = 0; iNode2 < nNodes; ++iNode2) {
            for (int iNode22 = 0; iNode22 < nNodes; ++iNode22) {
                if (iNode2 == iNode22 || cliques[iNode2] == null || cliques[iNode22] == null || !cliques[iNode2].containsAll(cliques[iNode22])) continue;
                cliques[iNode22] = null;
            }
        }
        if (this.m_debug) {
            int[] nNodeSet = new int[nNodes];
            for (iNode = 0; iNode < nNodes; ++iNode) {
                if (cliques[iNode] == null) continue;
                Iterator it = cliques[iNode].iterator();
                int k = 0;
                while (it.hasNext()) {
                    nNodeSet[k++] = (Integer)it.next();
                }
                for (int i = 0; i < cliques[iNode].size(); ++i) {
                    for (int j = 0; j < cliques[iNode].size(); ++j) {
                        if (i == j || bAdjacencyMatrix[nNodeSet[i]][nNodeSet[j]]) continue;
                        throw new Exception("Non clique" + i + " " + j);
                    }
                }
            }
        }
        return cliques;
    }

    public boolean[][] moralize(BayesNet bayesNet) {
        int nNodes = bayesNet.getNrOfNodes();
        boolean[][] bAdjacencyMatrix = new boolean[nNodes][nNodes];
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            ParentSet parents = bayesNet.getParentSets()[iNode];
            this.moralizeNode(parents, iNode, bAdjacencyMatrix);
        }
        return bAdjacencyMatrix;
    }

    private void moralizeNode(ParentSet parents, int iNode, boolean[][] bAdjacencyMatrix) {
        for (int iParent = 0; iParent < parents.getNrOfParents(); ++iParent) {
            int nParent = parents.getParent(iParent);
            if (this.m_debug && !bAdjacencyMatrix[iNode][nParent]) {
                System.out.println("Insert " + iNode + "--" + nParent);
            }
            bAdjacencyMatrix[iNode][nParent] = true;
            bAdjacencyMatrix[nParent][iNode] = true;
            for (int iParent2 = iParent + 1; iParent2 < parents.getNrOfParents(); ++iParent2) {
                int nParent2 = parents.getParent(iParent2);
                if (this.m_debug && !bAdjacencyMatrix[nParent2][nParent]) {
                    System.out.println("Mary " + nParent + "--" + nParent2);
                }
                bAdjacencyMatrix[nParent2][nParent] = true;
                bAdjacencyMatrix[nParent][nParent2] = true;
            }
        }
    }

    public boolean[][] fillIn(int[] order, boolean[][] bAdjacencyMatrix) {
        int nNodes = bAdjacencyMatrix.length;
        int[] inverseOrder = new int[nNodes];
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            inverseOrder[order[iNode]] = iNode;
        }
        for (int i = nNodes - 1; i >= 0; --i) {
            int iNode = order[i];
            for (int j = 0; j < i; ++j) {
                int iNode2 = order[j];
                if (!bAdjacencyMatrix[iNode][iNode2]) continue;
                for (int k = j + 1; k < i; ++k) {
                    int iNode3 = order[k];
                    if (!bAdjacencyMatrix[iNode][iNode3]) continue;
                    if (!(!this.m_debug || bAdjacencyMatrix[iNode2][iNode3] && bAdjacencyMatrix[iNode3][iNode2])) {
                        System.out.println("Fill in " + iNode2 + "--" + iNode3);
                    }
                    bAdjacencyMatrix[iNode2][iNode3] = true;
                    bAdjacencyMatrix[iNode3][iNode2] = true;
                }
            }
        }
        return bAdjacencyMatrix;
    }

    int[] getMaxCardOrder(boolean[][] bAdjacencyMatrix) {
        int nNodes = bAdjacencyMatrix.length;
        int[] order = new int[nNodes];
        if (nNodes == 0) {
            return order;
        }
        boolean[] bDone = new boolean[nNodes];
        order[0] = 0;
        bDone[0] = true;
        for (int iNode = 1; iNode < nNodes; ++iNode) {
            int nMaxCard = -1;
            int iBestNode = -1;
            for (int iNode2 = 0; iNode2 < nNodes; ++iNode2) {
                if (bDone[iNode2]) continue;
                int nCard = 0;
                for (int iNode3 = 0; iNode3 < nNodes; ++iNode3) {
                    if (!bAdjacencyMatrix[iNode2][iNode3] || !bDone[iNode3]) continue;
                    ++nCard;
                }
                if (nCard <= nMaxCard) continue;
                nMaxCard = nCard;
                iBestNode = iNode2;
            }
            order[iNode] = iBestNode;
            bDone[iBestNode] = true;
        }
        return order;
    }

    public void setEvidence(int nNode, int iValue) throws Exception {
        int iJtNode;
        if (this.m_root == null) {
            throw new Exception("Junction tree not initialize yet");
        }
        for (iJtNode = 0; !(iJtNode >= this.jtNodes.length || this.jtNodes[iJtNode] != null && this.jtNodes[iJtNode].contains(nNode)); ++iJtNode) {
        }
        if (this.jtNodes.length == iJtNode) {
            throw new Exception("Could not find node " + nNode + " in junction tree");
        }
        this.jtNodes[iJtNode].setEvidence(nNode, iValue);
    }

    public String toString() {
        return this.m_root.toString();
    }

    public double[] getMargin(int iNode) {
        return this.m_Margins[iNode];
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10154 $");
    }

    public static void main(String[] args) {
        try {
            BIFReader bayesNet = new BIFReader();
            bayesNet.processFile(args[0]);
            MarginCalculator dc = new MarginCalculator();
            dc.calcMargins(bayesNet);
            int iNode = 2;
            int iValue = 0;
            int iNode2 = 4;
            int iValue2 = 0;
            dc.setEvidence(iNode, iValue);
            dc.setEvidence(iNode2, iValue2);
            System.out.print(dc.toString());
            dc.calcFullMargins(bayesNet);
            dc.setEvidence(iNode, iValue);
            dc.setEvidence(iNode2, iValue2);
            System.out.println("==============");
            System.out.print(dc.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class JunctionTreeNode
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 650278019241175536L;
        BayesNet m_bayesNet;
        public int[] m_nNodes;
        int m_nCardinality;
        double[] m_fi;
        double[] m_P;
        double[][] m_MarginalP;
        JunctionTreeSeparator m_parentSeparator;
        public Vector<JunctionTreeNode> m_children;

        public void setParentSeparator(JunctionTreeSeparator parentSeparator) {
            this.m_parentSeparator = parentSeparator;
        }

        public void addChildClique(JunctionTreeNode child) {
            this.m_children.add(child);
        }

        public void initializeUp() {
            int iPos;
            this.m_P = new double[this.m_nCardinality];
            for (int iPos2 = 0; iPos2 < this.m_nCardinality; ++iPos2) {
                this.m_P[iPos2] = this.m_fi[iPos2];
            }
            int[] values = new int[this.m_nNodes.length];
            int[] order = new int[this.m_bayesNet.getNrOfNodes()];
            for (int iNode = 0; iNode < this.m_nNodes.length; ++iNode) {
                order[this.m_nNodes[iNode]] = iNode;
            }
            Iterator<JunctionTreeNode> iNode = this.m_children.iterator();
            while (iNode.hasNext()) {
                JunctionTreeNode element;
                JunctionTreeNode childNode = element = iNode.next();
                JunctionTreeSeparator separator = childNode.m_parentSeparator;
                for (int iPos3 = 0; iPos3 < this.m_nCardinality; ++iPos3) {
                    int i;
                    int iNodeCPT;
                    int iSepCPT = MarginCalculator.this.getCPT(separator.m_nNodes, separator.m_nNodes.length, values, order, this.m_bayesNet);
                    int n = iNodeCPT = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, values, order, this.m_bayesNet);
                    this.m_P[n] = this.m_P[n] * separator.m_fiChild[iSepCPT];
                    int n2 = i = 0;
                    values[n2] = values[n2] + 1;
                    while (i < this.m_nNodes.length && values[i] == this.m_bayesNet.getCardinality(this.m_nNodes[i])) {
                        values[i] = 0;
                        if (++i >= this.m_nNodes.length) continue;
                        int n3 = i;
                        values[n3] = values[n3] + 1;
                    }
                }
            }
            double sum = 0.0;
            for (iPos = 0; iPos < this.m_nCardinality; ++iPos) {
                sum += this.m_P[iPos];
            }
            iPos = 0;
            while (iPos < this.m_nCardinality) {
                int n = iPos++;
                this.m_P[n] = this.m_P[n] / sum;
            }
            if (this.m_parentSeparator != null) {
                this.m_parentSeparator.updateFromChild();
            }
        }

        public void initializeDown(boolean recursively) {
            if (this.m_parentSeparator == null) {
                this.calcMarginalProbabilities();
            } else {
                int iPos;
                this.m_parentSeparator.updateFromParent();
                int[] values = new int[this.m_nNodes.length];
                int[] order = new int[this.m_bayesNet.getNrOfNodes()];
                for (int iNode = 0; iNode < this.m_nNodes.length; ++iNode) {
                    order[this.m_nNodes[iNode]] = iNode;
                }
                for (int iPos2 = 0; iPos2 < this.m_nCardinality; ++iPos2) {
                    int i;
                    int iSepCPT = MarginCalculator.this.getCPT(this.m_parentSeparator.m_nNodes, this.m_parentSeparator.m_nNodes.length, values, order, this.m_bayesNet);
                    int iNodeCPT = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, values, order, this.m_bayesNet);
                    if (this.m_parentSeparator.m_fiChild[iSepCPT] > 0.0) {
                        int n = iNodeCPT;
                        this.m_P[n] = this.m_P[n] * (this.m_parentSeparator.m_fiParent[iSepCPT] / this.m_parentSeparator.m_fiChild[iSepCPT]);
                    } else {
                        this.m_P[iNodeCPT] = 0.0;
                    }
                    int n = i = 0;
                    values[n] = values[n] + 1;
                    while (i < this.m_nNodes.length && values[i] == this.m_bayesNet.getCardinality(this.m_nNodes[i])) {
                        values[i] = 0;
                        if (++i >= this.m_nNodes.length) continue;
                        int n2 = i;
                        values[n2] = values[n2] + 1;
                    }
                }
                double sum = 0.0;
                for (iPos = 0; iPos < this.m_nCardinality; ++iPos) {
                    sum += this.m_P[iPos];
                }
                iPos = 0;
                while (iPos < this.m_nCardinality) {
                    int n = iPos++;
                    this.m_P[n] = this.m_P[n] / sum;
                }
                this.m_parentSeparator.updateFromChild();
                this.calcMarginalProbabilities();
            }
            if (recursively) {
                Iterator<JunctionTreeNode> iterator = this.m_children.iterator();
                while (iterator.hasNext()) {
                    JunctionTreeNode element;
                    JunctionTreeNode childNode = element = iterator.next();
                    childNode.initializeDown(true);
                }
            }
        }

        void calcMarginalProbabilities() {
            int iNode;
            int[] values = new int[this.m_nNodes.length];
            int[] order = new int[this.m_bayesNet.getNrOfNodes()];
            this.m_MarginalP = new double[this.m_nNodes.length][];
            for (iNode = 0; iNode < this.m_nNodes.length; ++iNode) {
                order[this.m_nNodes[iNode]] = iNode;
                this.m_MarginalP[iNode] = new double[this.m_bayesNet.getCardinality(this.m_nNodes[iNode])];
            }
            for (int iPos = 0; iPos < this.m_nCardinality; ++iPos) {
                int i;
                int iNodeCPT = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, values, order, this.m_bayesNet);
                for (int iNode2 = 0; iNode2 < this.m_nNodes.length; ++iNode2) {
                    double[] dArray = this.m_MarginalP[iNode2];
                    int n = values[iNode2];
                    dArray[n] = dArray[n] + this.m_P[iNodeCPT];
                }
                int n = i = 0;
                values[n] = values[n] + 1;
                while (i < this.m_nNodes.length && values[i] == this.m_bayesNet.getCardinality(this.m_nNodes[i])) {
                    values[i] = 0;
                    if (++i >= this.m_nNodes.length) continue;
                    int n2 = i;
                    values[n2] = values[n2] + 1;
                }
            }
            for (iNode = 0; iNode < this.m_nNodes.length; ++iNode) {
                MarginCalculator.this.m_Margins[this.m_nNodes[iNode]] = this.m_MarginalP[iNode];
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            for (int iNode = 0; iNode < this.m_nNodes.length; ++iNode) {
                buf.append(this.m_bayesNet.getNodeName(this.m_nNodes[iNode]) + ": ");
                for (int iValue = 0; iValue < this.m_MarginalP[iNode].length; ++iValue) {
                    buf.append(this.m_MarginalP[iNode][iValue] + " ");
                }
                buf.append('\n');
            }
            Iterator<JunctionTreeNode> iterator = this.m_children.iterator();
            while (iterator.hasNext()) {
                JunctionTreeNode element;
                JunctionTreeNode childNode = element = iterator.next();
                buf.append("----------------\n");
                buf.append(childNode.toString());
            }
            return buf.toString();
        }

        void calculatePotentials(BayesNet bayesNet, Set<Integer> clique, boolean[] bDone) {
            this.m_fi = new double[this.m_nCardinality];
            int[] values = new int[this.m_nNodes.length];
            int[] order = new int[bayesNet.getNrOfNodes()];
            for (int iNode = 0; iNode < this.m_nNodes.length; ++iNode) {
                order[this.m_nNodes[iNode]] = iNode;
            }
            boolean[] bIsContained = new boolean[this.m_nNodes.length];
            for (int iNode = 0; iNode < this.m_nNodes.length; ++iNode) {
                int nNode = this.m_nNodes[iNode];
                bIsContained[iNode] = !bDone[nNode];
                for (int iParent = 0; iParent < bayesNet.getNrOfParents(nNode); ++iParent) {
                    int nParent = bayesNet.getParent(nNode, iParent);
                    if (clique.contains(nParent)) continue;
                    bIsContained[iNode] = false;
                }
                if (!bIsContained[iNode]) continue;
                bDone[nNode] = true;
                if (!MarginCalculator.this.m_debug) continue;
                System.out.println("adding node " + nNode);
            }
            for (int iPos = 0; iPos < this.m_nCardinality; ++iPos) {
                int i;
                int iCPT = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, values, order, bayesNet);
                this.m_fi[iCPT] = 1.0;
                for (int iNode = 0; iNode < this.m_nNodes.length; ++iNode) {
                    if (!bIsContained[iNode]) continue;
                    int nNode = this.m_nNodes[iNode];
                    int[] nNodes = bayesNet.getParentSet(nNode).getParents();
                    int iCPT2 = MarginCalculator.this.getCPT(nNodes, bayesNet.getNrOfParents(nNode), values, order, bayesNet);
                    double f = bayesNet.getDistributions()[nNode][iCPT2].getProbability(values[iNode]);
                    int n = iCPT;
                    this.m_fi[n] = this.m_fi[n] * f;
                }
                int n = i = 0;
                values[n] = values[n] + 1;
                while (i < this.m_nNodes.length && values[i] == bayesNet.getCardinality(this.m_nNodes[i])) {
                    values[i] = 0;
                    if (++i >= this.m_nNodes.length) continue;
                    int n2 = i;
                    values[n2] = values[n2] + 1;
                }
            }
        }

        JunctionTreeNode(Set<Integer> clique, BayesNet bayesNet, boolean[] bDone) {
            this.m_bayesNet = bayesNet;
            this.m_children = new Vector();
            this.m_nNodes = new int[clique.size()];
            int iPos = 0;
            this.m_nCardinality = 1;
            for (Integer integer : clique) {
                int iNode = integer;
                this.m_nNodes[iPos++] = iNode;
                this.m_nCardinality *= bayesNet.getCardinality(iNode);
            }
            this.calculatePotentials(bayesNet, clique, bDone);
        }

        boolean contains(int nNode) {
            for (int m_nNode : this.m_nNodes) {
                if (m_nNode != nNode) continue;
                return true;
            }
            return false;
        }

        public void setEvidence(int nNode, int iValue) throws Exception {
            int iPos;
            int[] values = new int[this.m_nNodes.length];
            int[] order = new int[this.m_bayesNet.getNrOfNodes()];
            int nNodeIdx = -1;
            for (int iNode = 0; iNode < this.m_nNodes.length; ++iNode) {
                order[this.m_nNodes[iNode]] = iNode;
                if (this.m_nNodes[iNode] != nNode) continue;
                nNodeIdx = iNode;
            }
            if (nNodeIdx < 0) {
                throw new Exception("setEvidence: Node " + nNode + " not found in this clique");
            }
            for (int iPos2 = 0; iPos2 < this.m_nCardinality; ++iPos2) {
                int i;
                if (values[nNodeIdx] != iValue) {
                    int iNodeCPT = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, values, order, this.m_bayesNet);
                    this.m_P[iNodeCPT] = 0.0;
                }
                int n = i = 0;
                values[n] = values[n] + 1;
                while (i < this.m_nNodes.length && values[i] == this.m_bayesNet.getCardinality(this.m_nNodes[i])) {
                    values[i] = 0;
                    if (++i >= this.m_nNodes.length) continue;
                    int n2 = i;
                    values[n2] = values[n2] + 1;
                }
            }
            double sum = 0.0;
            for (iPos = 0; iPos < this.m_nCardinality; ++iPos) {
                sum += this.m_P[iPos];
            }
            iPos = 0;
            while (iPos < this.m_nCardinality) {
                int n = iPos++;
                this.m_P[n] = this.m_P[n] / sum;
            }
            this.calcMarginalProbabilities();
            this.updateEvidence(this);
        }

        void updateEvidence(JunctionTreeNode source) {
            if (source != this) {
                int iPos;
                int[] values = new int[this.m_nNodes.length];
                int[] order = new int[this.m_bayesNet.getNrOfNodes()];
                for (int iNode = 0; iNode < this.m_nNodes.length; ++iNode) {
                    order[this.m_nNodes[iNode]] = iNode;
                }
                int[] nChildNodes = source.m_parentSeparator.m_nNodes;
                int nNumChildNodes = nChildNodes.length;
                for (int iPos2 = 0; iPos2 < this.m_nCardinality; ++iPos2) {
                    int i;
                    int iNodeCPT = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, values, order, this.m_bayesNet);
                    int iChildCPT = MarginCalculator.this.getCPT(nChildNodes, nNumChildNodes, values, order, this.m_bayesNet);
                    if (source.m_parentSeparator.m_fiParent[iChildCPT] != 0.0) {
                        int n = iNodeCPT;
                        this.m_P[n] = this.m_P[n] * (source.m_parentSeparator.m_fiChild[iChildCPT] / source.m_parentSeparator.m_fiParent[iChildCPT]);
                    } else {
                        this.m_P[iNodeCPT] = 0.0;
                    }
                    int n = i = 0;
                    values[n] = values[n] + 1;
                    while (i < this.m_nNodes.length && values[i] == this.m_bayesNet.getCardinality(this.m_nNodes[i])) {
                        values[i] = 0;
                        if (++i >= this.m_nNodes.length) continue;
                        int n2 = i;
                        values[n2] = values[n2] + 1;
                    }
                }
                double sum = 0.0;
                for (iPos = 0; iPos < this.m_nCardinality; ++iPos) {
                    sum += this.m_P[iPos];
                }
                iPos = 0;
                while (iPos < this.m_nCardinality) {
                    int n = iPos++;
                    this.m_P[n] = this.m_P[n] / sum;
                }
                this.calcMarginalProbabilities();
            }
            for (JunctionTreeNode element : this.m_children) {
                JunctionTreeNode childNode = element;
                if (childNode == source) continue;
                childNode.initializeDown(true);
            }
            if (this.m_parentSeparator != null) {
                this.m_parentSeparator.updateFromChild();
                this.m_parentSeparator.m_parentNode.updateEvidence(this);
                this.m_parentSeparator.updateFromParent();
            }
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 10154 $");
        }
    }

    public class JunctionTreeSeparator
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 6502780192411755343L;
        int[] m_nNodes;
        int m_nCardinality;
        double[] m_fiParent;
        double[] m_fiChild;
        JunctionTreeNode m_parentNode;
        JunctionTreeNode m_childNode;
        BayesNet m_bayesNet;

        JunctionTreeSeparator(Set<Integer> separator, BayesNet bayesNet, JunctionTreeNode childNode, JunctionTreeNode parentNode) {
            this.m_nNodes = new int[separator.size()];
            int iPos = 0;
            this.m_nCardinality = 1;
            for (Integer element : separator) {
                int iNode = element;
                this.m_nNodes[iPos++] = iNode;
                this.m_nCardinality *= bayesNet.getCardinality(iNode);
            }
            this.m_parentNode = parentNode;
            this.m_childNode = childNode;
            this.m_bayesNet = bayesNet;
        }

        public void updateFromParent() {
            double[] fis = this.update(this.m_parentNode);
            if (fis == null) {
                this.m_fiParent = null;
            } else {
                int iPos;
                this.m_fiParent = fis;
                double sum = 0.0;
                for (iPos = 0; iPos < this.m_nCardinality; ++iPos) {
                    sum += this.m_fiParent[iPos];
                }
                iPos = 0;
                while (iPos < this.m_nCardinality) {
                    int n = iPos++;
                    this.m_fiParent[n] = this.m_fiParent[n] / sum;
                }
            }
        }

        public void updateFromChild() {
            double[] fis = this.update(this.m_childNode);
            if (fis == null) {
                this.m_fiChild = null;
            } else {
                int iPos;
                this.m_fiChild = fis;
                double sum = 0.0;
                for (iPos = 0; iPos < this.m_nCardinality; ++iPos) {
                    sum += this.m_fiChild[iPos];
                }
                iPos = 0;
                while (iPos < this.m_nCardinality) {
                    int n = iPos++;
                    this.m_fiChild[n] = this.m_fiChild[n] / sum;
                }
            }
        }

        public double[] update(JunctionTreeNode node) {
            if (node.m_P == null) {
                return null;
            }
            double[] fi = new double[this.m_nCardinality];
            int[] values = new int[node.m_nNodes.length];
            int[] order = new int[this.m_bayesNet.getNrOfNodes()];
            for (int iNode = 0; iNode < node.m_nNodes.length; ++iNode) {
                order[node.m_nNodes[iNode]] = iNode;
            }
            for (int iPos = 0; iPos < node.m_nCardinality; ++iPos) {
                int i;
                int iSepCPT;
                int iNodeCPT = MarginCalculator.this.getCPT(node.m_nNodes, node.m_nNodes.length, values, order, this.m_bayesNet);
                int n = iSepCPT = MarginCalculator.this.getCPT(this.m_nNodes, this.m_nNodes.length, values, order, this.m_bayesNet);
                fi[n] = fi[n] + node.m_P[iNodeCPT];
                int n2 = i = 0;
                values[n2] = values[n2] + 1;
                while (i < node.m_nNodes.length && values[i] == this.m_bayesNet.getCardinality(node.m_nNodes[i])) {
                    values[i] = 0;
                    if (++i >= node.m_nNodes.length) continue;
                    int n3 = i;
                    values[n3] = values[n3] + 1;
                }
            }
            return fi;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 10154 $");
        }
    }
}

