/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatMenuItemRenderer;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.util.LoggingFacade;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class FlatPopupMenuUI
extends BasicPopupMenuUI
implements FlatStylingSupport.StyleableUI {
    private PropertyChangeListener propertyChangeListener;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;

    public static ComponentUI createUI(JComponent c) {
        return new FlatPopupMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installStyle();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.oldStyleValues = null;
        this.borderShared = null;
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        LayoutManager layout = this.popupMenu.getLayout();
        if (layout == null || layout instanceof UIResource) {
            this.popupMenu.setLayout(new FlatMenuLayout(this.popupMenu, 1));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = FlatStylingSupport.createPropertyChangeListener(this.popupMenu, this::installStyle, null);
        this.popupMenu.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.popupMenu.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.popupMenu, "PopupMenu"));
        }
        catch (RuntimeException ex) {
            LoggingFacade.INSTANCE.logSevere(null, ex);
        }
    }

    protected void applyStyle(Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String key, Object value) {
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, key, value, this.popupMenu, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this, this.popupMenu.getBorder());
    }

    protected static class FlatMenuLayout
    extends DefaultMenuLayout {
        public FlatMenuLayout(Container target, int axis) {
            super(target, axis);
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            FlatMenuItemRenderer.clearClientProperties(target);
            return super.preferredLayoutSize(target);
        }
    }
}

