/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Copyable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.gui.ProgrammaticProperty;

public abstract class Kernel
implements Serializable,
OptionHandler,
CapabilitiesHandler,
RevisionHandler {
    private static final long serialVersionUID = -6102771099905817064L;
    protected Instances m_data;
    protected boolean m_Debug = false;
    protected boolean m_ChecksTurnedOff = false;
    protected boolean m_DoNotCheckCapabilities = false;

    @ProgrammaticProperty
    public void setDoNotCheckCapabilities(boolean doNotCheckCapabilities) {
    }

    public boolean getDoNotCheckCapabilities() {
        return true;
    }

    public abstract String globalInfo();

    public abstract double eval(int var1, int var2, Instance var3) throws Exception;

    public abstract void clean();

    public abstract int numEvals();

    public abstract int numCacheHits();

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = Option.listOptionsForClassHierarchy(this.getClass(), Kernel.class);
        result.addElement(new Option("\tEnables debugging output (if available) to be printed.\n\t(default: off)", "output-debug-info", 0, "-output-debug-info"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        Option.setOptionsForHierarchy(options, this, Kernel.class);
        this.setDebug(Utils.getFlag("output-debug-info", options));
        this.setChecksTurnedOff(Utils.getFlag("no-checks", options));
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        for (String s : Option.getOptionsForHierarchy(this, Kernel.class)) {
            result.add(s);
        }
        if (this.getDebug()) {
            result.add("-output-debug-info");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setDebug(boolean value) {
        this.m_Debug = value;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "Turns on the output of debugging information.";
    }

    @ProgrammaticProperty
    public void setChecksTurnedOff(boolean value) {
    }

    public boolean getChecksTurnedOff() {
        return true;
    }

    protected void initVars(Instances data) {
        this.m_data = data;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.enableAll();
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14534 $");
    }

    public void buildKernel(Instances data) throws Exception {
        this.initVars(data);
    }

    public static Kernel makeCopy(Kernel kernel) throws Exception {
        if (kernel instanceof Copyable) {
            return (Kernel)((Copyable)((Object)kernel)).copy();
        }
        return (Kernel)new SerializedObject(kernel).getObject();
    }

    public static Kernel[] makeCopies(Kernel model, int num) throws Exception {
        if (model == null) {
            throw new Exception("No model kernel set");
        }
        Kernel[] kernels = new Kernel[num];
        if (model instanceof Copyable) {
            for (int i = 0; i < kernels.length; ++i) {
                kernels[i] = (Kernel)((Copyable)((Object)model)).copy();
            }
        } else {
            SerializedObject so = new SerializedObject(model);
            for (int i = 0; i < kernels.length; ++i) {
                kernels[i] = (Kernel)so.getObject();
            }
        }
        return kernels;
    }

    public static Kernel forName(String kernelName, String[] options) throws Exception {
        return (Kernel)Utils.forName(Kernel.class, kernelName, options);
    }
}

