# extract computed tree out of the weka result file

import os
import glob

folder_path = 'results/weka'

for filename in glob.glob(os.path.join(folder_path, '*.txt')):
    with open(filename, 'r') as f:
        # name of output file (there we append whether it is unpruned, raised, or replaced)
        my_output = filename.rpartition('/')[-1][:-4]
        # indication of whether parts of the tree are read
        found1 = False
        found2 = False
        for line in f:
            #if line.startswith('Options:'):
            #    if '-U' in line:
            #        my_output = my_output + '-unpruned.txt'
            #    elif '-S' in line:
            #        my_output = my_output + '-replacement.txt'
            #    else:
            #        my_output = my_output + '-raising.txt'
            if found2 is True:
                print(line)
                outfile.write(line)
            if found2 is True and len(line.strip()) == 0 :
                found2 = False
            if found1 is True:
                found2 = True
                found1 = False
                outfile = open('results/weka-trees/' + my_output, 'w+')
            if line.startswith('------------------'):
                found1 = True

            # also write down total number of examples and number of errors, and number of inner nodes
            if line.startswith('Total Number of Instances'):
                outfile.write(line.rsplit()[-1] + '\n')
            if line.startswith('Incorrectly Classified Instances'):
                outfile.write(line.rsplit()[-3] + '\n')
            if line.startswith('Number of Leaves'):
                outfile.write(str(int(line.rsplit()[-1])-1) + '\n')
        outfile.close()
