# compute number d of dimensions used in a tree and also d_T the max number of dims on any root-leaf-path

import os
# networkx to store the input tree

folder_path = 'results/weka-trees'

ext = ('unpru', 'rais', 'repl')

outfile = open("paraValues.txt", 'w+')

for files in os.listdir(folder_path):
    if files.endswith(ext):
        f = open( folder_path + "/" + files, 'r')
        # to compute d simply check how many different d-i-s are used
        used_dims = set()

        # for computation of d_T
        # aim: save the weka tree as a directed tree with arcs from the root to the leaf to compute d_T fast
        path_dims = []
        # depth of last node
        depth_last = -1

        # the parameter we aim to compute
        d_T = 0
        for line in f:
            line = line.split()
            for i in range(len(line)):
                if line[i].startswith('d'):
                    # for d
                    dim = int(line[i][1:])
                    used_dims.add(dim)

                    # for d_T
                    # deeper in the path
                    #print(line, dim, i, depth_last)
                    if i > depth_last:
                        path_dims.append(dim)
                    # right child of parent is explored next (could also be a leaf)
                    if i < depth_last:
                        to_remove = depth_last - i
                        path_dims = path_dims[:-to_remove]
                    # new leaf which could use more dimensions
                    if i == depth_last:
                        d_T = max(d_T, len(set(path_dims)))
                    depth_last = i

        outfile.write(files.rpartition('/')[-1] + "," + str(len(used_dims)) + "," + str(d_T) + "\n")
outfile.close()





































