#!/usr/bin/env fish

# Ensure we're in the correct directory
# Uncomment if you need to change directory first
# cd /path/to/your/project

# Iterate through all .arff files in data/weka/
for data_file in data/weka/*.arff
    # Extract the base filename without path and extension
    set base_name (basename $data_file .arff)
    
    # Construct the corresponding tree file path
    set tree_file "results/weka-trees/$base_name-repl"
    set tree_file_unpru "results/weka-trees/$base_name-unpru"
    
    # Check if the corresponding tree file exists
    if test -e $tree_file
        # Option 1: kadj 2 and kexch 0
        echo "python3 local-searcher/main.py --krais 0 --kadj 2 --kexch 0 --krepl 0 --data $data_file --tree $tree_file --min-errors-output results/local-searcher/$base_name-kadj2-kexch0"
        
        # Option 2: kadj 0 and kexch 2
        echo "python3 local-searcher/main.py --krais 0 --kadj 0 --kexch 2 --krepl 0 --data $data_file --tree $tree_file --min-errors-output results/local-searcher/$base_name-kadj0-kexch2"

	echo "python3 local-searcher/main.py --kadj 0 --kexch 1 --krais 0 --data $data_file --tree $tree_file --min-errors-output results/local-searcher/$base_name-kadj0-kexch1-kreplinf"
	
	echo "python3 local-searcher/main.py --kadj 1 --kexch 0 --krais 0 --data $data_file --tree $tree_file --min-errors-output results/local-searcher/$base_name-kadj1-kexch0-kreplinf"

	echo "python3 local-searcher/main.py --kadj 0 --kexch 2 --krais 0 --data $data_file --tree $tree_file --min-errors-output results/local-searcher/$base_name-kadj0-kexch2-kreplinf"
	
	echo "python3 local-searcher/main.py --kadj 2 --kexch 0 --krais 0 --data $data_file --tree $tree_file --min-errors-output results/local-searcher/$base_name-kadj2-kexch0-kreplinf"

	echo "python3 local-searcher/main.py --kadj 0 --kexch 1 --krais 0 --data $data_file --tree $tree_file_unpru --min-errors-output results/local-searcher/$base_name-unpru-kadj0-kexch1-kreplinf"
	
	echo "python3 local-searcher/main.py --kadj 1 --kexch 0 --krais 0 --data $data_file --tree $tree_file_unpru --min-errors-output results/local-searcher/$base_name-unpru-kadj1-kexch0-kreplinf"

	echo "python3 local-searcher/main.py --kadj 0 --kexch 2 --krais 0 --data $data_file --tree $tree_file_unpru --min-errors-output results/local-searcher/$base_name-unpru-kadj0-kexch2-kreplinf"
	
	echo "python3 local-searcher/main.py --kadj 2 --kexch 0 --krais 0 --data $data_file --tree $tree_file_unpru --min-errors-output results/local-searcher/$base_name-unpru-kadj2-kexch0-kreplinf"

	echo "python3 local-searcher/main.py --krais 0 --kadj 3 --kexch 0 --krepl 0 --data $data_file --tree $tree_file --min-errors-output results/local-searcher/$base_name-kadj3-kexch0"

	echo "python3 local-searcher/main.py --krais 0 --kadj 3 --kexch 0 --krepl 0 --data $data_file --tree $tree_file --min-errors-output results/local-searcher/$base_name-kadj3-kexch0"

	echo "python3 local-searcher/main.py --krais 0 --kadj 1 --kexch 1 --krepl 0 --data $data_file --tree $tree_file --min-errors-output results/local-searcher/$base_name-kadj1-kexch1"

	echo "python3 local-searcher/main.py --krais 0 --kadj 1 --kexch 1 --krepl 0 --data $data_file --tree $tree_file --min-errors-output results/local-searcher/$base_name-kadj1-kexch1"
    else
        echo "# Warning: Tree file not found for $data_file" >&2
    end
end
