# transform the input data set into the format of WEKA

import os
import glob
import subprocess as sp

folder_path = 'data'

for filename in glob.glob(os.path.join(folder_path, '*.csv')):
    with open(filename, 'r') as f:
        print(filename)
        # name of output file
        my_output = 'data/weka/' + filename.rpartition('/')[-1][:-4]
        my_output += '_data.arff'
        sp.call(["java", "-jar", "WekaConverter.jar", filename, my_output])
