# transform the input data set into the format of WEKA

import os
import glob

folder_path = 'data/weka'

bashfile = open("runWeka.sh", 'w+')

for filename in glob.glob(os.path.join(folder_path, '*.arff')):
    with open(filename, 'r') as f:
        print(filename)
        # name of output file
        # make 3 different runs,
        # -U for unpruned
        # -S for replacement
        #    for raising (no additional arguments)
        my_output = 'results/weka/' + filename.rpartition('/')[-1][:-5]
        my_output_unpruned = my_output + '-unpru.txt'
        my_output_replacement = my_output + '-repl.txt'
        #my_output_raising = my_output + '-rais.txt'

        # now add 3 nes lines to the bash script
        ####bashfile.write("java --add-opens java.base/java.lang=ALL-UNNAMED -cp weka-3-8-6/weka.jar weka.classifiers.trees.J48 -t " + filename + " -no-cv -B -M 1 -J  >" + my_output_raising + "\n")
        bashfile.write("java --add-opens java.base/java.lang=ALL-UNNAMED -cp weka-3-8-6/weka.jar weka.classifiers.trees.J48 -t " + filename + " -no-cv -B -M 1 -J -S  >" + my_output_replacement + "\n")
        bashfile.write("java --add-opens java.base/java.lang=ALL-UNNAMED  -cp weka-3-8-6/weka.jar weka.classifiers.trees.J48 -t " + filename + " -no-cv -B -M 1 -J -U  >" + my_output_unpruned + "\n")
        
        ####bashfile.write("java -cp weka-3-8-6/weka.jar weka.classifiers.trees.J48 -t " + filename + " -no-cv -B -M 0 -J  >" + my_output_raising + "\n")
        #bashfile.write("java -cp weka-3-8-6/weka.jar weka.classifiers.trees.J48 -t " + filename + " -no-cv -B -M 0 -J -S  >" + my_output_replacement + "\n")
        #bashfile.write("java -cp weka-3-8-6/weka.jar weka.classifiers.trees.J48 -t " + filename + " -no-cv -B -M 0 -J -U  >" + my_output_unpruned + "\n")

bashfile.close()
