# Code

This code accompanies the NeurIPS 2023 submission "Variational Monte Carlo on a Budget - Fine-tuning pre-trained Neural Wavefunctions". 
Details regarding the licence can be found in the corresponding file.

# Datasets
All geometries, datasets and computed energies can be found under code/datasets/db.

## Reproducing results

In the supplementary information folder we added all necessary configs and setup files to reproduce 
the experiments including a snapshot of the conda environment used to perform all experiments (see _conda_env.txt_).

To install the codebase one needs to call `pip install -e .` and update to the correct jax and jaxlib version including CUDA, i.e 

`pip install --upgrade "jax==0.3.23 jaxlib=0.3.22+cuda11.cudnn82 dm-haiku=0.0.9" -f https://storage.googleapis.com/jax-releases/jax_cuda_releases.html`

Additionally, we added the final checkpoint of our large pre-trained model and a pre-trained PhisNet orbital descriptor model to reproduce the fine-tuning experiments. 

For all figures in the main paper we have a folder containing a config template and a setup.py file with the option to change the 
name of the experiments to reproduce panels of each of the figures. If the code is properly installed calling:
`python setup.py 
`
should be sufficient to start the experiment. Keep in mind that the computations are quite resource intensive and a
GPU with enough memory is necessary. The final folder includes the configs for the ablation experiment.


