#!/usr/bin/env python
import os.path
import shutil
from deeperwin.cli import main
from deeperwin.run_tools.geometry_database import load_geometries, load_datasets, Geometry
from deeperwin.configuration import Configuration
from deeperwin.checkpoints import load_run
import ruamel.yaml

# Settings
dry_run = False

# Dataset names: N2 exp - N2_stretching_GerardEtAl2022; C3H4 global rotation - C3H4_dist_rotated_20geoms; C3H4 torsion - C3H4_rotated_torsion_angle_90degrees
dataset = "Kinal_Piecuch_Bicyclobutane"

checkpoint = "midimol_2023-05-01_699torsion_nc_by_std_256k.zip"
phisnet_checkpoint = "phisnet_3LayerL2_47kGeoms_174Epochs.zip"

# Constants
reuse_config_fname = "config_reuse_template_shared.yml"
calc_name = checkpoint.split("/")[-1].replace(".zip", "")
calc_dir = "reuse_" + calc_name

# Create directory for reusing from one specific checkpoint
if not os.path.isdir(calc_dir):
    os.mkdir(calc_dir)
os.chdir(calc_dir)

# Load model config from checkpoint and use it to replace the reuse model config
with open("../" + reuse_config_fname) as f:
    reuse_config = ruamel.yaml.YAML().load(f)
checkpoint_config = load_run(checkpoint, load_pkl=False, parse_config=False).config
reuse_config["model"] = checkpoint_config["model"]
reuse_config["reuse"]["path"] = checkpoint
reuse_config["reuse"]["path_phisnet"] = phisnet_checkpoint
reuse_config["experiment_name"] = calc_dir
with open("config.yml", "w") as f:
    ruamel.yaml.YAML().dump(reuse_config, f)

# Submit the actual calculations
print(f"Generating job for {dataset}")
cmd = "setup -i config.yml"
cmd += f" -p physical {dataset}"
if dry_run:
    cmd += " --dry-run"
main(cmd)
os.chdir("..")
  
